% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalbin.R
\name{evalbin}
\alias{evalbin}
\title{Model evalbin}
\usage{
evalbin(dataset, pred, rvar, lev = "", qnt = 10, cost = 1, margin = 2,
  train = "", method = "xtile", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{pred}{Predictions or predictors}

\item{rvar}{Response variable}

\item{lev}{The level in the response variable defined as _success_}

\item{qnt}{Number of bins to create}

\item{cost}{Cost for each connection (e.g., email or mailing)}

\item{margin}{Margin on each customer purchase}

\item{train}{Use data from training ("Training"), validation ("Validation"), both ("Both"), or all data ("All") to evaluate model evalbin}

\item{method}{Use either ntile or xtile to split the data (default is xtile)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of results
}
\description{
Model evalbin
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/evalbin.html} for an example in Radiant
}
\examples{
result <- evalbin("titanic", c("age","fare"), "survived")

}
\seealso{
\code{\link{summary.evalbin}} to summarize results

\code{\link{plot.evalbin}} to plot results
}
