% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{predict.regress}
\alias{predict.regress}
\title{Predict method for the regress function}
\usage{
\method{predict}{regress}(object, pred_data = "", pred_cmd = "",
  conf_lev = 0.95, se = TRUE, dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{regress}}}

\item{pred_data}{Name of the dataset to use for prediction}

\item{pred_cmd}{Command used to generate data for prediction}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the regress function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
result <- regress("diamonds", "price", c("carat","clarity"))
predict(result, pred_cmd = "carat = 1:10")
predict(result, pred_cmd = "clarity = levels(clarity)")
result <- regress("diamonds", "price", c("carat","clarity"), int = c("carat:clarity"))
dpred <<- getdata("diamonds") \%>\% slice(1:10)
predict(result, pred_data = "dpred")
rm(dpred, envir = .GlobalEnv)

}
\seealso{
\code{\link{regress}} to generate the result

\code{\link{summary.regress}} to summarize results

\code{\link{plot.regress}} to plot results
}
