% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{plot.model.predict}
\alias{plot.model.predict}
\title{Plot method for model.predict functions}
\usage{
\method{plot}{model.predict}(x, xvar = "", facet_row = ".",
  facet_col = ".", color = "none", conf_lev = 0.95, ...)
}
\arguments{
\item{x}{Return value from predict functions (e.g., predict.regress)}

\item{xvar}{Variable to display along the X-axis of the plot}

\item{facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{color}{Adds color to a scatter plot to generate a heat map. For a line plot one line is created for each group and each is assigned a different color}

\item{conf_lev}{Confidence level to use for prediction intervals (.95 is the default)}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for model.predict functions
}
\examples{
regress(diamonds, "price", c("carat", "clarity")) \%>\%
  predict(pred_cmd = "carat = 1:10") \%>\%
  plot(xvar = "carat")
logistic(titanic, "survived", c("pclass", "sex", "age"), lev = "Yes") \%>\%
  predict(pred_cmd = c("pclass = levels(pclass)", "sex = levels(sex)", "age = 0:100")) \%>\%
  plot(xvar = "age", color = "sex", facet_col = "pclass")

}
\seealso{
\code{\link{predict.regress}} to generate predictions

\code{\link{predict.logistic}} to generate predictions
}
