% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.R
\name{gbt}
\alias{gbt}
\title{Gradient Boosted Trees using XGBoost}
\usage{
gbt(
  dataset,
  rvar,
  evar,
  type = "classification",
  lev = "",
  max_depth = 6,
  learning_rate = 0.3,
  min_split_loss = 0,
  min_child_weight = 1,
  subsample = 1,
  nrounds = 100,
  early_stopping_rounds = 10,
  nthread = 12,
  wts = "None",
  seed = NA,
  data_filter = "",
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{type}{Model type (i.e., "classification" or "regression")}

\item{lev}{Level to use as the first column in prediction output}

\item{max_depth}{Maximum 'depth' of tree}

\item{learning_rate}{Learning rate (eta)}

\item{min_split_loss}{Minimal improvement (gamma)}

\item{min_child_weight}{Minimum number of instances allowed in each node}

\item{subsample}{Subsample ratio of the training instances (0-1)}

\item{nrounds}{Number of trees to create}

\item{early_stopping_rounds}{Early stopping rule}

\item{nthread}{Number of parallel threads to use. Defaults to 12 if available}

\item{wts}{Weights to use in estimation}

\item{seed}{Random seed to use as the starting point}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}

\item{...}{Further arguments to pass to xgboost}
}
\value{
A list with all variables defined in gbt as an object of class gbt
}
\description{
Gradient Boosted Trees using XGBoost
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/gbt.html} for an example in Radiant
}
\examples{
\dontrun{
gbt(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\% summary()
gbt(titanic, "survived", c("pclass", "sex")) \%>\% str()
}
gbt(titanic, "survived", c("pclass", "sex"), lev = "Yes", early_stopping_rounds = 0) \%>\% summary()
gbt(titanic, "survived", c("pclass", "sex"), early_stopping_rounds = 0) \%>\% str()
gbt(titanic, "survived", c("pclass", "sex"), eval_metric = paste0("error@", 0.5 / 6)) \%>\% str()
gbt(diamonds, "price", c("carat", "clarity"), type = "regression") \%>\% summary()
rig_wrap <- function(preds, dtrain) {
  labels <- xgboost::getinfo(dtrain, "label")
  value <- rig(preds, labels, lev = 1)
  list(metric = "rig", value = value)
}
gbt(titanic, "survived", c("pclass", "sex"), eval_metric = rig_wrap, maximize = TRUE) \%>\% str()
}
\seealso{
\code{\link{summary.gbt}} to summarize results

\code{\link{plot.gbt}} to plot results

\code{\link{predict.gbt}} for prediction
}
