% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmap.R
\name{pmap}
\alias{pmap}
\title{Attribute based brand maps}
\usage{
pmap(dataset, brand, attr, pref = "", nr_dim = 2, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{brand}{A character variable with brand names}

\item{attr}{Names of numeric variables}

\item{pref}{Names of numeric brand preference measures}

\item{nr_dim}{Number of dimensions}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables defined in the function as an object of class pmap
}
\description{
Attribute based brand maps
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer","brand","high_end:business")

}
\seealso{
\code{\link{summary.pmap}} to summarize results

\code{\link{plot.pmap}} to plot results
}
