% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_factor.R
\name{summary.full_factor}
\alias{summary.full_factor}
\title{Summary method for the full_factor function}
\usage{
\method{summary}{full_factor}(object, cutoff = 0, fsort = FALSE, dec = 2,
  ...)
}
\arguments{
\item{object}{Return value from \code{\link{full_factor}}}

\item{cutoff}{Show only loadings with (absolute) values above cutoff (default = 0)}

\item{fsort}{Sort factor loadings}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the full_factor function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/full_factor.html} for an example in Radiant
}
\examples{
result <- full_factor("diamonds",c("price","carat","depth","table","x"))
summary(result)
summary(result, cutoff = 0, fsort = FALSE)
summary(result, cutoff = 0, fsort = TRUE)
summary(result, cutoff = .5, fsort = TRUE)
diamonds \%>\% full_factor(c("price","carat","depth","table","x")) \%>\% summary
diamonds \%>\% full_factor(c("price","carat","depth","table","x")) \%>\% summary(cutoff = .5)

}
\seealso{
\code{\link{full_factor}} to calculate results

\code{\link{plot.full_factor}} to plot results
}
