% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pmap.R
\name{summary.pmap}
\alias{summary.pmap}
\title{Summarize method for the pmap function}
\usage{
\method{summary}{pmap}(object, pmap_cutoff = 0, ...)
}
\arguments{
\item{object}{Return value from \code{\link{pmap}}}

\item{pmap_cutoff}{Show only loadings with (absolute) values above pmap_cutoff (default = 0)}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summarize method for the pmap function
}
\details{
See \url{http://mostly-harmless.github.io/radiant/marketing/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer","Brand","HighEnd:Business")
summary(result)
summary(result, pmap_cutoff = .3)
result <- pmap("computer","Brand","HighEnd:Dated", pmap_pref = c("Innovative","Business"))
summary(result)
}
\seealso{
\code{\link{pmap}} to calculate results

\code{\link{plot.pmap}} to plot results
}

