% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_info.R
\name{RN_info}
\alias{RN_info}
\title{Quick table of Radionuclide Data from the RadData package}
\usage{
RN_info(RN_select)
}
\arguments{
\item{RN_select}{identify the radionuclide of interest in the format "Es-254m"}
}
\value{
a table including half-life, decay modes, decay progeny, and branch fractions
}
\description{
Access a quick summary of radionuclide data. This is for convenience only and does not replace a more comprehensive view as is available in the Radiological Toolbox <doi:10.2172/1201298>
}
\examples{
Es_254m <- RN_info("Es-254m") #saves output to global environment
RN_info("Cf-252")
RN_info("Cs-137")
RN_info("Am-241")
}
\seealso{
Other radionuclides: 
\code{\link{RN_Spec_Act}()},
\code{\link{RN_bin_screen_phot}()},
\code{\link{RN_index_screen}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_plot_spectrum}()},
\code{\link{RN_save_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
