% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_dicom.R
\name{dicom_header_as_matrix}
\alias{dicom_header_as_matrix}
\title{Get the header information as a matrix}
\usage{
dicom_header_as_matrix(dicom_data, slice_idx = NA)
}
\arguments{
\item{dicom_data}{DICOM data returned by \code{\link{read_dicom}}}

\item{slice_idx}{1-based slice index. If NA, all slices will be included. Won't work if
multiple slices are included in only one image file.}
}
\value{
Data frame containing one record for each header attribute. Note that
if all slices are included, fields that appear more than once (including tag and name)
in a given slice header will be excluded from the values reported for that slice.
Each column contains all header attributes for one slice, therefore, values are
represented as strings even if they are conceptually numeric.
}
\description{
Get the header information as a matrix
}
\examples{
data(sample_dicom_img)
dicom_header_as_matrix(sample_dicom_img)
}
