% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rags2ridgesFused.R
\name{KLdiv.fused}
\alias{KLdiv.fused}
\title{Fused Kullback-Leibler divergence for sets of distributions}
\usage{
KLdiv.fused(MtestList, MrefList, StestList, SrefList, ns, symmetric = FALSE)
}
\arguments{
\item{MtestList}{A \code{list} of mean vectors of the approximating
multivariate normal distribution for each class. Assumed to be zero vectors
if not supplied.}

\item{MrefList}{A \code{list} of mean vectors of the reference multivariate
normal distribution for each class. Assumed to be zero vectors if not
supplied.}

\item{StestList}{A \code{list} of covariance matrices of the approximating
multivariate normal distribtuion for each class. Usually a \code{list} of
sample covariance matrices.}

\item{SrefList}{A \code{list} of covariance matrices of the references
multivariate normal distribtuion for each class. Usually a \code{list} of
the population or reference covariance matrices.}

\item{ns}{a \code{numeric} of the same length as the previous arguments
giving the sample sizes. Used as weights in the weighted mean.}

\item{symmetric}{a \code{logical} indicating if original symmetric version of
KL divergence should be calculated.}
}
\value{
Function returns a \code{numeric} representing the (optionally
  symmetric) fused Kullback-Leibler divergence.
}
\description{
Function calculating the Kullback-Leibler divergence between two sets of
multivariate normal distributions. In other words, it calculates a weigthed
mean of Kullback-Leibler divergences between multiple paired normal
distributions.
}
\examples{
# Create some toy data
n <- c(40, 60, 80)
p <- 10
Stest <- replicate(length(n), diag(p), simplify = FALSE)
Sref <- createS(n, p = p)

KLdiv.fused(StestList = Stest, SrefList = Sref, ns = n, symmetric = FALSE)
KLdiv.fused(StestList = Stest, SrefList = Sref, ns = n, symmetric = TRUE)

}
\seealso{
\code{\link{KLdiv}}
}
\author{
Anders Ellern Bilgrau, Wessel N. van Wieringen, Carel F.W. Peeters
  <carel.peeters@wur.nl>
}
