% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{implied_volatilities_with_rates_struct}
\alias{implied_volatilities_with_rates_struct}
\title{Find the implied volatility of european-exercise options with a term structure of interest rates}
\usage{
implied_volatilities_with_rates_struct(
  option_price,
  callput,
  S0,
  K,
  discount_factor_fcn,
  time,
  const_default_intensity = 0,
  divrate = 0,
  borrow_cost = 0,
  dividends = NULL,
  relative_tolerance = 1e-06,
  max.iter = 100,
  max_vola = 4
)
}
\arguments{
\item{option_price}{Present option values (may be a vector)}

\item{callput}{1 for calls, -1 for puts (may be a vector)}

\item{S0}{initial underlying prices (may be a vector)}

\item{K}{strikes (may be a vector)}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t}, with arguments \code{T}, \code{t}}

\item{time}{Time from \code{0} until expirations (may be a vector)}

\item{const_default_intensity}{hazard rates of underlying default  (may be a vector)}

\item{divrate}{A continuous rate for dividends and other cashflows such as foreign interest rates  (may be a vector)}

\item{borrow_cost}{A continuous rate for stock borrow costs  (may be a vector)}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}.  Fixed
dividends will be converted to proprtional for purposes of this algorithm.}

\item{relative_tolerance}{Relative tolerance in option price to achieve before halting the search}

\item{max.iter}{Number of iterations to try before abandoning the search}

\item{max_vola}{Maximum volatility to try in the search}
}
\value{
Scalar volatilities
}
\description{
Use the provided discount factor function to infer constant short rates applicable to each
  expiration time, then use the Black-Scholes formula to generate European option values and run them
  through Newton's method until a constant volatility matching each provided
  option price has been found.
}
\details{
Differs from \code{implied_volatility_with_term_struct} by first computing constant interest rates
for each option, and then calling \code{implied_volatilities}
}
\examples{
  d_fcn = function(T,t) {exp(-0.03*(T-t))}
  implied_volatilities_with_rates_struct(c(23,24,25),
         c(-1,1,1), 100, 100,
         discount_factor_fcn=d_fcn, time=c(4,4,5))

}
\seealso{
\code{\link{implied_volatility}} for simpler cases with constant
  parameters, \code{\link{implied_volatilities}} for the underlying
  algorithm with constant rates, \code{\link{implied_volatility_with_term_struct}} when
  volatilities or survival probabilities also have a nontrivial term structure

Other Implied Volatilities: 
\code{\link{american_implied_volatility}()},
\code{\link{equivalent_bs_vola_to_jump}()},
\code{\link{equivalent_jump_vola_to_bs}()},
\code{\link{fit_variance_cumulation}()},
\code{\link{implied_jump_process_volatility}()},
\code{\link{implied_volatilities}()},
\code{\link{implied_volatility_with_term_struct}()},
\code{\link{implied_volatility}()}

Other European Options: 
\code{\link{black_scholes_on_term_structures}()},
\code{\link{blackscholes}()},
\code{\link{implied_volatilities}()},
\code{\link{implied_volatility_with_term_struct}()},
\code{\link{implied_volatility}()}

Other Equity Independent Default Intensity: 
\code{\link{american_implied_volatility}()},
\code{\link{american}()},
\code{\link{black_scholes_on_term_structures}()},
\code{\link{blackscholes}()},
\code{\link{equivalent_bs_vola_to_jump}()},
\code{\link{equivalent_jump_vola_to_bs}()},
\code{\link{implied_volatilities}()},
\code{\link{implied_volatility_with_term_struct}()},
\code{\link{implied_volatility}()}
}
\concept{Equity Independent Default Intensity}
\concept{European Options}
\concept{Implied Volatilities}
