% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{integrate_pde}
\alias{integrate_pde}
\title{Numerically integrate the pricing differential equation}
\usage{
integrate_pde(
  z,
  min_num_time_steps,
  S0,
  Tmax,
  instruments,
  stock_level_fcn,
  discount_factor_fcn,
  default_intensity_fcn,
  variance_cumulation_fcn,
  dividends = NULL
)
}
\arguments{
\item{z}{Space grid value morphable to stock prices using \code{stock_level_fcn}}

\item{min_num_time_steps}{The minimum number of timesteps used.  Calls,
puts and coupons may result in extra timesteps taken.}

\item{S0}{Time zero price of the base equity}

\item{Tmax}{The maximum time on the grid, from which
all backwardation steps will take place.}

\item{instruments}{A list of instruments to be priced.  Each
one must have a \code{strike} and a \code{optionality_fcn}, as
with \code{\link{GridPricedInstrument}} and its subclasses.}

\item{stock_level_fcn}{A function for changing space grid value to stock
prices, with arguments \code{z} and \code{t}}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{default_intensity_fcn}{A function for computing default intensity
occurring during this timestep, dependent on time and stock price, with
arguments \code{t}, \code{S}.}

\item{variance_cumulation_fcn}{A function for computing total stock variance
occurring during this timestep, with arguments \code{T}, \code{t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}}
}
\value{
A grid of present values of derivative prices, adapted to \code{z} at
  each timestep.  Time zero value will appear in the first index.
}
\description{
Use an implicit integration scheme to numerically integrate
the pricing differential equation for each of the given instruments,
backwardating from time \code{Tmax} to time 0.
}
\seealso{
Other Implicit Grid Solver: 
\code{\link{construct_implicit_grid_structure}()},
\code{\link{find_present_value}()},
\code{\link{form_present_value_grid}()},
\code{\link{infer_conforming_time_grid}()},
\code{\link{iterate_grid_from_timestep}()},
\code{\link{take_implicit_timestep}()},
\code{\link{timestep_instruments}()}
}
\concept{Implicit Grid Solver}
