% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainette.R
\name{rainette}
\alias{rainette}
\title{Corpus clustering based on the Reinert method - Simple clustering}
\usage{
rainette(
  dtm,
  k = 10,
  min_uc_size = 10,
  min_split_members = 5,
  cc_test = 0.3,
  tsj = 3,
  min_members
)
}
\arguments{
\item{dtm}{quanteda dfm object of documents to cluster, usually the
result of \code{\link[=split_segments]{split_segments()}}}

\item{k}{maximum number of clusters to compute}

\item{min_uc_size}{minimum number of forms by document}

\item{min_split_members}{don't try to split groups with fewer members}

\item{cc_test}{contingency coefficient value for feature selection}

\item{tsj}{minimum frequency value for feature selection}

\item{min_members}{deprecated, use \code{min_split_members} instead}
}
\value{
The result is a list of both class \code{hclust} and \code{rainette}. Besides the elements
of an \code{hclust} object, two more results are available :
\itemize{
\item \code{uce_groups} give the group of each document for each k
\item \code{group} give the group of each document for the maximum value of k available
}
}
\description{
Corpus clustering based on the Reinert method - Simple clustering
}
\details{
See the references for original articles on the method. Computations and results may differ
quite a bit, see the package vignettes for more details.

The dtm object is automatically converted to boolean.
}
\examples{
\donttest{
library(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
dtm <- dfm(corpus, remove = stopwords("en"), tolower = TRUE, remove_punct = TRUE)
dtm <- dfm_wordstem(dtm, language = "english")
dtm <- dfm_trim(dtm, min_termfreq = 3)
res <- rainette(dtm, k = 3)
}

}
\references{
\itemize{
\item Reinert M, Une méthode de classification descendante hiérarchique : application à l'analyse lexicale par contexte, Cahiers de l'analyse des données, Volume 8, Numéro 2, 1983. \url{http://www.numdam.org/item/?id=CAD_1983__8_2_187_0}
\item Reinert M., Alceste une méthodologie d'analyse des données textuelles et une application: Aurelia De Gerard De Nerval, Bulletin de Méthodologie Sociologique, Volume 26, Numéro 1, 1990. \url{https://doi.org/10.1177/075910639002600103}
}
}
\seealso{
\code{\link[=split_segments]{split_segments()}}, \code{\link[=rainette2]{rainette2()}}, \code{\link[=cutree_rainette]{cutree_rainette()}}, \code{\link[=rainette_plot]{rainette_plot()}}, \code{\link[=rainette_explor]{rainette_explor()}}
}
