% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{td_accountData}
\alias{td_accountData}
\title{Get account balances positions, and orders returned as a list}
\usage{
td_accountData(output = "df", accessToken = NULL)
}
\arguments{
\item{output}{Use 'df' for a list of 3 data frames containing balances,
positions, and orders. Otherwise the data will be returned as a list of
lists}

\item{accessToken}{A valid Access Token must be set using
\code{\link{td_auth_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a list of requested account details
}
\description{
Retrieves a account data for the accounts linked to the Access Token
}
\details{
The output will be either a list of three data frames or a list of three
lists that contain balances, positions, and orders for TD Ameritrade accounts
linked to the access token. For historical orders, see
\code{\link{td_orderSearch}}. The default is for a data frame output which is
much cleaner.
}
\examples{
\dontrun{

# Get stored refresh token
refreshToken = readRDS('/secure/location/')

# Generate a new access token
accessToken = td_auth_accessToken(refreshToken, 'consumerKey')

# Passing the accessToken is optional. The default will return balances
asDF = td_accountData()
asList = td_accountData('list',accessToken)

}
}
