/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_Multinomial;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import java.util.Arrays;
import java.util.Random;

public class Multinomial
extends UnivariateDistribution {
    private static final long serialVersionUID = 8587756877237341367L;
    private double[] probabilities;

    public Multinomial(Variable var1) {
        this.var = var1;
        this.probabilities = new double[this.var.getNumberOfStates()];
        for (int i = 0; i < this.var.getNumberOfStates(); ++i) {
            this.probabilities[i] = 1.0 / (double)this.var.getNumberOfStates();
        }
    }

    @Override
    public double[] getParameters() {
        double[] param = new double[this.getNumberOfParameters()];
        System.arraycopy(this.probabilities, 0, param, 0, this.probabilities.length);
        return param;
    }

    @Override
    public int getNumberOfParameters() {
        return this.probabilities.length;
    }

    public void setProbabilities(double[] probabilities1) {
        this.probabilities = probabilities1;
    }

    public void setProbabilityOfState(int state, double prob) {
        this.probabilities[state] = prob;
    }

    public double getProbabilityOfState(int state) {
        return this.probabilities[state];
    }

    public double getProbabilityOfState(String name) {
        FiniteStateSpace stateSpace = (FiniteStateSpace)this.var.getStateSpaceType();
        return this.probabilities[stateSpace.getIndexOfState(name)];
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    @Override
    public double getLogProbability(double value) {
        return Math.log(this.probabilities[(int)value]);
    }

    @Override
    public double sample(Random rand) {
        double b = 0.0;
        double r = rand.nextDouble();
        for (int i = 0; i < this.probabilities.length; ++i) {
            if (!((b += this.probabilities[i]) > r)) continue;
            return i;
        }
        return this.probabilities.length - 1;
    }

    @Override
    public UnivariateDistribution deepCopy(Variable variable) {
        Multinomial copy = new Multinomial(variable);
        copy.probabilities = Arrays.copyOf(this.getProbabilities(), this.getProbabilities().length);
        return copy;
    }

    @Override
    public String label() {
        return "Multinomial";
    }

    @Override
    public void randomInitialization(Random random) {
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.probabilities[i] = random.nextDouble() + 0.2;
        }
        this.probabilities = Utils.normalize(this.probabilities);
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof Multinomial) {
            return this.equalDist((Multinomial)dist, threshold);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[ ");
        int size = this.getProbabilities().length;
        for (int i = 0; i < size; ++i) {
            str.append(this.getProbabilities()[i]);
            if (i >= size - 1) continue;
            str.append(", ");
        }
        str.append(" ]");
        return str.toString();
    }

    public boolean equalDist(Multinomial dist, double threshold) {
        boolean equals = true;
        for (int i = 0; i < this.probabilities.length; ++i) {
            equals = equals && Math.abs(this.getProbabilityOfState(i) - dist.getProbabilityOfState(i)) <= threshold;
        }
        return equals;
    }

    public EF_Multinomial toEFUnivariateDistribution() {
        EF_Multinomial efMultinomial = new EF_Multinomial(this.getVariable());
        MomentParameters momentParameters = efMultinomial.createZeroMomentParameters();
        for (int i = 0; i < this.getVariable().getNumberOfStates(); ++i) {
            momentParameters.set(i, this.getProbabilityOfState(i));
        }
        efMultinomial.setMomentParameters(momentParameters);
        return efMultinomial;
    }
}

