/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.Multinomial;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Dirichlet;
import eu.amidst.core.exponentialfamily.EF_SparseMultinomial_Dirichlet;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.ParameterVariables;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.SparseVectorDefaultValue;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.stateSpaceTypes.SparseFiniteStateSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class EF_SparseMultinomial
extends EF_UnivariateDistribution {
    public EF_SparseMultinomial(Variable var) {
        if (!var.isSparseMultinomial()) {
            throw new UnsupportedOperationException("Creating a SparseMultinomial EF distribution for a non-multinomial variable.");
        }
        this.parents = new ArrayList();
        this.var = var;
        int nstates = var.getNumberOfStates();
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.getSparseNaturalParameters().setDefaultValue(-Math.log(nstates));
        this.getSparseMomentParameters().setDefaultValue(1.0 / (double)nstates);
    }

    private SparseVectorDefaultValue getSparseNaturalParameters() {
        return (SparseVectorDefaultValue)this.naturalParameters;
    }

    private SparseVectorDefaultValue getSparseMomentParameters() {
        return (SparseVectorDefaultValue)this.momentParameters;
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return 0.0;
    }

    @Override
    public double computeLogNormalizer() {
        double sum = 0.0;
        SparseVectorDefaultValue naturalSparse = this.getSparseNaturalParameters();
        for (Integer index : naturalSparse.getNonZeroEntries()) {
            sum += Math.exp(this.naturalParameters.get(index));
        }
        return Math.log(sum += (double)naturalSparse.getNDefaultValues() * Math.exp(naturalSparse.getDefaultValue()));
    }

    @Override
    public Vector createZeroVector() {
        return new SparseVectorDefaultValue(this.var.getNumberOfStates(), 0.0);
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        SufficientStatistics vec = this.createZeroSufficientStatistics();
        vec.set((int)val, 1.0);
        return vec;
    }

    @Override
    public Vector getExpectedParameters() {
        return this.momentParameters;
    }

    @Override
    public double computeLogProbabilityOf(double val) {
        return this.naturalParameters.dotProduct(this.getSufficientStatistics(val)) + this.computeLogBaseMeasure(val) - this.computeLogNormalizer();
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        this.getSparseNaturalParameters().reset();
        for (Integer index : this.getSparseMomentParameters().getNonZeroEntries()) {
            this.naturalParameters.set(index, Math.log(this.momentParameters.get(index)));
        }
        this.getSparseNaturalParameters().setDefaultValue(Math.log(this.getSparseMomentParameters().getDefaultValue()));
    }

    @Override
    public void fixNumericalInstability() {
        this.naturalParameters = SparseVectorDefaultValue.logNormalize(this.getSparseNaturalParameters());
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        this.getSparseMomentParameters().reset();
        for (Integer index : this.getSparseNaturalParameters().getNonZeroEntries()) {
            this.momentParameters.set(index, Math.exp(this.naturalParameters.get(index)));
        }
        this.getSparseMomentParameters().setDefaultValue(Math.exp(this.getSparseNaturalParameters().getDefaultValue()));
        SparseVectorDefaultValue.normalize(this.getSparseMomentParameters());
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return this.var.getNumberOfStates();
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable var) {
        EF_SparseMultinomial copy = new EF_SparseMultinomial(var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random random) {
        throw new UnsupportedOperationException("");
    }

    public Multinomial toUnivariateDistribution() {
        throw new UnsupportedOperationException("");
    }

    @Override
    public List<EF_ConditionalDistribution> toExtendedLearningDistribution(ParameterVariables variables, String nameSuffix) {
        Variable varDirichlet = variables.newVariable(this.var.getName() + "_DirichletParameter_" + nameSuffix + "_" + variables.getNumberOfVars(), DistributionTypeEnum.DIRICHLET_PARAMETER, new SparseFiniteStateSpace(this.var.getNumberOfStates()));
        EF_Dirichlet uni = (EF_Dirichlet)((DistributionType)varDirichlet.getDistributionType()).newEFUnivariateDistribution();
        return Arrays.asList(new EF_SparseMultinomial_Dirichlet(this.var, varDirichlet), uni);
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        SufficientStatistics vector = this.createZeroSufficientStatistics();
        ((SparseVectorDefaultValue)vector).setDefaultValue(1.0 / (double)this.var.getNumberOfStates());
        return vector;
    }
}

