/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.utils.OptionParser;

public interface AmidstOptionsHandler {
    public String listOptions();

    public String listOptionsRecursively();

    public void loadOptions();

    default public String classNameID() {
        return this.getClass().getName();
    }

    default public void setOptions(String[] args) {
        OptionParser.setArgsOptions(this.classNameID(), args);
        this.loadOptions();
    }

    default public void loadOptionsFromFile(String fileName) {
        OptionParser.setConfFileName(fileName);
        OptionParser.loadFileOptions();
        OptionParser.loadDefaultOptions(this.classNameID());
        this.loadOptions();
    }

    default public String getOption(String optionName) {
        return OptionParser.parse(this.classNameID(), this.listOptions(), optionName);
    }

    default public int getIntOption(String optionName) {
        return Integer.parseInt(this.getOption(optionName));
    }

    default public double getDoubleOption(String optionName) {
        return Double.parseDouble(this.getOption(optionName));
    }

    default public boolean getBooleanOption(String optionName) {
        return this.getOption(optionName).equalsIgnoreCase("true") || this.getOption(optionName).equalsIgnoreCase("T");
    }

    public static String listOptionsRecursively(Class obj) {
        try {
            return ((AmidstOptionsHandler)obj.newInstance()).listOptionsRecursively();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class " + obj + " does not exist");
        }
    }
}

