/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;

public class Serialization {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeObject(Object object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(object);
                out.close();
                byte[] result = bos.toByteArray();
                bos.close();
                byte[] byArray = result;
                return byArray;
            }
            catch (Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    return null;
                }
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public static <T> T deserializeObject(byte[] bytes) {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Object result = in.readObject();
            bis.close();
            in.close();
            object = result;
        }
        catch (ClassNotFoundException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }

    public static <T> T deepCopy(T object) {
        return Serialization.deserializeObject(Serialization.serializeObject(object));
    }
}

