/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Vector;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class SparseVectorDefaultValue
implements Vector,
NaturalParameters,
MomentParameters,
SufficientStatistics,
Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    Map<Integer, Double> values;
    final int dimension;
    double defaultValue = 0.0;

    public SparseVectorDefaultValue(int dimension, double defaultValue) {
        this.dimension = dimension;
        this.values = new HashMap<Integer, Double>();
        this.defaultValue = defaultValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void reset() {
        this.values = new HashMap<Integer, Double>();
    }

    public int getNDefaultValues() {
        return this.dimension - this.values.keySet().size();
    }

    @Override
    public double get(int i) {
        if (this.values.containsKey(i)) {
            return this.values.get(i);
        }
        return this.defaultValue;
    }

    @Override
    public void set(int i, double val) {
        this.values.put(i, val);
    }

    @Override
    public int size() {
        return this.dimension;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (Double aDouble : this.values.values()) {
            sum += aDouble.doubleValue();
        }
        return sum += this.defaultValue * (double)this.getNDefaultValues();
    }

    @Override
    public void sum(Vector vector) {
        SparseVectorDefaultValue sparseVector = (SparseVectorDefaultValue)vector;
        if (sparseVector.getDefaultValue() == 0.0) {
            for (Integer integer : sparseVector.getNonZeroEntries()) {
                if (!(Math.abs(sparseVector.get(integer)) > 1.0E-5)) continue;
                this.set(integer, this.get(integer) + sparseVector.get(integer));
            }
        } else {
            for (Integer integer : this.getNonZeroEntries()) {
                this.set(integer, this.get(integer) + sparseVector.get(integer));
            }
            for (Integer integer : sparseVector.getNonZeroEntries()) {
                if (this.values.containsKey(integer)) continue;
                this.set(integer, this.getDefaultValue() + sparseVector.get(integer));
            }
            this.setDefaultValue(this.getDefaultValue() + sparseVector.getDefaultValue());
        }
    }

    @Override
    public void substract(Vector vector) {
        SparseVectorDefaultValue sparseVector = (SparseVectorDefaultValue)vector;
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) - sparseVector.get(integer));
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer)) continue;
            this.set(integer, this.defaultValue - sparseVector.get(integer));
        }
        this.setDefaultValue(this.getDefaultValue() - sparseVector.getDefaultValue());
    }

    @Override
    public void copy(Vector vector) {
        SparseVectorDefaultValue sparseVector = (SparseVectorDefaultValue)vector;
        this.values = new HashMap<Integer, Double>(sparseVector.values);
        this.defaultValue = sparseVector.getDefaultValue();
    }

    @Override
    public void divideBy(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) / val);
        }
        this.setDefaultValue(this.getDefaultValue() / val);
    }

    @Override
    public void multiplyBy(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) * val);
        }
        this.setDefaultValue(this.getDefaultValue() * val);
    }

    @Override
    public void sumConstant(double val) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, this.get(integer) + val);
        }
        this.setDefaultValue(this.getDefaultValue() + val);
    }

    @Override
    public double dotProduct(Vector vector) {
        SparseVectorDefaultValue sparseVector = (SparseVectorDefaultValue)vector;
        if (sparseVector.getDefaultValue() == 0.0) {
            double sum = 0.0;
            for (Integer integer : sparseVector.getNonZeroEntries()) {
                sum += this.get(integer) * sparseVector.get(integer);
            }
            return sum;
        }
        if (this.getDefaultValue() == 0.0) {
            double sum = 0.0;
            for (Integer integer : this.getNonZeroEntries()) {
                sum += this.get(integer) * sparseVector.get(integer);
            }
            return sum;
        }
        double sum = 0.0;
        double cont = this.dimension;
        for (Integer integer : this.getNonZeroEntries()) {
            if (!sparseVector.values.containsKey(integer)) {
                sum += this.get(integer) * sparseVector.getDefaultValue();
                cont -= 1.0;
                continue;
            }
            sum += this.get(integer) * sparseVector.get(integer);
            cont -= 1.0;
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer)) continue;
            sum += this.getDefaultValue() * sparseVector.get(integer);
            cont -= 1.0;
        }
        return sum += cont * this.getDefaultValue() * sparseVector.getDefaultValue();
    }

    @Override
    public boolean equalsVector(Vector vector, double threshold) {
        SparseVectorDefaultValue sparseVector = (SparseVectorDefaultValue)vector;
        if (Math.abs(this.getDefaultValue() - sparseVector.getDefaultValue()) > threshold) {
            return false;
        }
        if ((double)Math.abs(this.getNDefaultValues() - sparseVector.getNDefaultValues()) > threshold) {
            return false;
        }
        for (Integer integer : this.getNonZeroEntries()) {
            if (!(Math.abs(this.get(integer) - sparseVector.get(integer)) > threshold)) continue;
            return false;
        }
        for (Integer integer : sparseVector.getNonZeroEntries()) {
            if (this.values.containsKey(integer) || !(Math.abs(-sparseVector.get(integer)) > threshold)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String output() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append(this.defaultValue);
        stringBuilder.append(",");
        for (Integer integer : this.getNonZeroEntries()) {
            stringBuilder.append("(");
            stringBuilder.append(integer);
            stringBuilder.append(",");
            stringBuilder.append(this.get(integer));
            stringBuilder.append(")");
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public Set<Integer> getNonZeroEntries() {
        return this.values.keySet();
    }

    public Map<Integer, Double> getValues() {
        return this.values;
    }

    public static SparseVectorDefaultValue logNormalize(SparseVectorDefaultValue vector) {
        double maxValue = vector.defaultValue;
        for (Integer index : vector.getNonZeroEntries()) {
            double val = vector.get(index);
            if (!(val > maxValue)) continue;
            maxValue = val;
        }
        for (Integer index : vector.getNonZeroEntries()) {
            vector.set(index, vector.get(index) - maxValue);
        }
        vector.setDefaultValue(vector.getDefaultValue() - maxValue);
        return vector;
    }

    public static SparseVectorDefaultValue normalize(SparseVectorDefaultValue vector) {
        double sum = vector.sum();
        for (Integer index : vector.getNonZeroEntries()) {
            vector.set(index, vector.get(index) / sum);
        }
        vector.setDefaultValue(vector.getDefaultValue() / sum);
        return vector;
    }

    public void apply(Function<Double, Double> function) {
        for (Integer integer : this.getNonZeroEntries()) {
            this.set(integer, function.apply(this.get(integer)));
        }
        this.setDefaultValue(function.apply(this.getDefaultValue()));
    }

    public double sumApply(Function<Double, Double> function) {
        double sum = 0.0;
        for (Integer integer : this.getNonZeroEntries()) {
            sum += function.apply(this.get(integer)).doubleValue();
        }
        return sum += function.apply(this.defaultValue) * (double)this.getNDefaultValues();
    }
}

