% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hadaPar.R
\name{hadaPar}
\alias{hadaPar}
\title{Representing Hadamard Randomization}
\usage{
hadaPar(N, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{hadaPar}.
}
\description{
Represents the randomization procedure Hadamard Randomization.
}
\details{
Hadamard randomization has been proposed by R.A. Bailey. The key idea is to
use the columns of a special Hadamard Matrix as a randomization scheme. The
implemented algorithm uses the Hadamard Matrix with \code{N=12} columns
proposed in the paper, see references.
}
\note{
\code{getProb} and \code{getAllSeq} are currently only supported for \code{hadaPar}
with total sample size \code{N=12}.
}
\references{
R.A. Bailey and P.R. Nelson (2003) Hadamard Randomization: A valid restriction
of random permuted blocks. \emph{Biometrical Journal}, \strong{45}, 554-60.
}
\seealso{
Other randomization procedures: \code{\link{bsdPar}};
  \code{\link{crPar}}; \code{\link{createParam}};
  \code{\link{ebcPar}}; \code{\link{mpPar}};
  \code{\link{pbrPar}}; \code{\link{rarPar}};
  \code{\link{rpbrPar}}; \code{\link{rtbdPar}};
  \code{\link{tbdPar}}; \code{\link{udPar}}
}

