% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,comparison,character-method}
\alias{plot,comparison,missing-method}
\title{Generic plotting of comparison objects}
\usage{
plot(x, y, ...)

\S4method{plot}{comparison,character}(x, y)

\S4method{plot}{comparison,missing}(x, y)
}
\arguments{
\item{x}{object of class \code{comparison}.}

\item{y}{character \code{"boxplot"}, or \code{"violin"}, or \code{"missing"}.}

\item{...}{\code{"missing"}}
}
\value{
A plot created with the additional package \code{ggplot2}.
}
\description{
Generic plotting of comparison objects
}
\details{
Creates a box- or violinplot of an object  \code{x} of the class \code{comparison}.
}
\examples{
# compare Random Allocation Rule and Big Stick for N = 4
# with respect to the correct guesses
RAR <- getAllSeq(rarPar(4))
BSD <- getAllSeq(bsdPar(4, mti = 2))
corGuess <- corGuess("CS")
comp <- compare(corGuess, RAR, BSD)
plot(comp)
}
\seealso{
\code{\link{compare}} for creating \code{S4} objects of the class \code{comparison}
}

