% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_rs.R
\name{cluster_rs}
\alias{cluster_rs}
\title{Cluster Random Sampling}
\usage{
cluster_rs(
  clusters = NULL,
  n = NULL,
  n_unit = NULL,
  prob = NULL,
  prob_unit = NULL,
  simple = FALSE,
  check_inputs = TRUE
)
}
\arguments{
\item{clusters}{A vector of length N that indicates which cluster each unit belongs to.}

\item{n}{Use for a design in which n clusters are sampled. (optional)}

\item{n_unit}{unique(n_unit) will be passed to \code{n}. Must be the same for all units (optional)}

\item{prob}{Use for a design in which either floor(N_clusters*prob) or ceiling(N_clusters*prob) clusters are sampled. The probability of being sampled is exactly prob because with probability 1-prob, floor(N_clusters*prob) clusters will be sampled and with probability prob, ceiling(N_clusters*prob) clusters will be sampled. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_unit}{unique(prob_unit) will be passed to the prob argument and must be the same for all units.}

\item{simple}{logical, defaults to FALSE. If TRUE, simple random sampling of clusters. When simple = TRUE, please do not specify n.}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A numeric vector of length N that indicates if a unit is sampled (1) or not (0).
}
\description{
cluster_rs implements a random sampling procedure in which groups of units are sampled together (as a cluster). This function conducts complete random sampling at the cluster level, unless simple = TRUE, in which case \code{\link{simple_rs}} analogues are used.
}
\examples{
clusters <- rep(letters, times=1:26)

S <- cluster_rs(clusters = clusters)
table(S, clusters)

S <- cluster_rs(clusters = clusters, n = 13)
table(S, clusters)

}
