% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_set.R
\name{rmap_connect}
\alias{rmap_connect}
\title{rangeMapper connect}
\usage{
rmap_connect(path = ":memory:", overwrite = FALSE)
}
\arguments{
\item{path}{filepath . When not specified, an \verb{in-memory} file is created.}

\item{overwrite}{when TRUE, the file is removed and the project re-initiated.}
}
\value{
an object of class rmapConnection
}
\description{
Connect to a new or an existing rangeMapper project.
}
\details{
An empty \code{rangeMapper} file is an sqlite database with five system tables:
\itemize{
\item \strong{rmap_nfo}        containing the package version, the crs string, the canvas type and the bounding box.
\item \strong{rmap_master}    a table similar with the in-build \code{sqlite_master} table holding information about the
tables created or importing while working on the project.
\item \strong{canvas_ranges}  a table that makes the link between the \code{canvas} and any entities usually species
mapped on the canvas.
\item \strong{wkt_canvas}    a table containing the canvas polygons as wkt binary.
\item \strong{wkt_ranges}    a table containing the range  polygons (usually species distribution ranges) as wkt binary.
}

If any of system tables is changed or missing then the file is considered corrupted and cannot be open with \code{rmap_connect()}.
}
\examples{
con = rmap_connect()
class(con)
dbDisconnect(con)
}
