% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holdoutRF.R
\name{holdoutRF}
\alias{holdoutRF}
\title{Hold-out random forests}
\usage{
holdoutRF(formula, data, ...)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character} describing the model to fit.}

\item{data}{Training data of class \code{data.frame}, \code{matrix} or \code{gwaa.data} (GenABEL).}

\item{...}{Further arguments passed to ranger().}
}
\value{
Hold-out random forests with variable importance.
}
\description{
Grow two random forests on two cross-validation folds. 
Instead of out-of-bag data, the other fold is used to compute permutation importance.
Related to the novel permutation variable importance by Janitza et al. (2015).
}
\author{
Marvin N. Wright
}
\references{
Janitza, S., Celik, E. & Boulesteix, A.-L., (2015). A computationally fast variable importance test for random forest for high dimensional data, Technical Report 185, University of Munich, \url{https://epub.ub.uni-muenchen.de/25587}. \cr
}
\seealso{
\code{\link{ranger}}
}

