% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_beads.R
\name{PlotBeads}
\alias{PlotBeads}
\title{Illustrate beading plot}
\usage{
PlotBeads(
  data,
  scaleX = "Rank",
  txtValue = "Effects",
  color = NULL,
  lgcBlind = FALSE,
  szPnt = NULL,
  szFntTtl = NULL,
  szFntTtlX = NULL,
  szFntX = NULL,
  szFntY = NULL,
  szFntTxt = NULL,
  szFntLgnd = NULL,
  rotateTxt = 60
)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{scaleX}{STRING for indicating scale on the x axis.}

\item{txtValue}{STRING for indicating labels of metrics or effects on each point.}

\item{color}{LIST of colors for treatments in a network meta-analysis.}

\item{lgcBlind}{LOGIC value for indicating whether to display with color-blind
friendly.}

\item{szPnt}{NUMERIC value for indicating point size of ranking metrics.}

\item{szFntTtl}{NUMERIC value for indicating font size of main title.}

\item{szFntTtlX}{NUMERIC value for indicating font size of title on X-axis.}

\item{szFntX}{NUMERIC value for indicating font size of numeric scale on X-axis.}

\item{szFntY}{NUMERIC value for indicating font size of outcome name(s).}

\item{szFntTxt}{NUMERIC value for indicating font size of value of each point.}

\item{szFntLgnd}{NUMERIC value for indicating legend font size.}

\item{rotateTxt}{NUMERIC value between 0 and 360 for rotating labels of text values
of each point.}
}
\value{
\strong{PlotBeads()} returns a beading plot.
}
\description{
\strong{PlotBeads()} is a function for illustrating beading plot.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#nma.1 <- GetMetrics(nma, outcome = "HbA1c.random", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)
#nma.2 <- GetMetrics(nma, outcome = "HbA1c.common", prefer = "small", metrics = "SUCRA",
#model = "common", simt = 1000)

# Combine metrics of multiple outcomes
#dataMetrics <- rbind(nma.1, nma.2)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate beading plot
#PlotBeads(data = dataRankinma)
## End(Not run)

}
\references{
Chen, C., Chuang, Y.C., Chan, E., Chen, J.H., Hou, W.H., & Kang, E. (2023).
Beading plot: A novel graphics for ranking interventions in network evidence.
PREPRINT (Version 1) available at Research Square.
}
\seealso{
\code{\link{GetMetrics}}, \code{\link{SetMetrics}}
}
\author{
Chiehfeng Chen & Enoch Kang
}
