% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmall.R
\name{rmall}
\alias{rmall}
\title{Random Mallows generation.}
\usage{
rmall(I, pi0, theta, R = length(pi0))
}
\arguments{
\item{I}{Numeric indicating the number of observations to be drawn.}

\item{pi0}{Vector specifying the consensus (modal probability) ranking.}

\item{theta}{Numeric specifying the Mallows scale parameter.}

\item{R}{Numeric specifying the length of the (partial) rankings to be drawn.}
}
\value{
Matrix of rankings, one row per ranking.
}
\description{
This function randomly generates rankings from a Mallows distribution.
}
\examples{
rmall(I=5,pi0=1:5,theta=1,R=3)
rmall(I=10,pi0=1:5,theta=1)
 
}
