% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{extract.meta}
\alias{extract.meta}
\title{Extract Template Metadata}
\usage{
extract.meta(
  x,
  title,
  regex,
  short = NULL,
  trim.white = TRUE,
  mandatory = TRUE,
  default.value = NULL,
  field.length = 1000,
  ...
)
}
\arguments{
\item{x}{a string containing template metadata}

\item{title}{a string containing metadata field title (can be regex-powered)}

\item{regex}{a string with regular expression to match field value}

\item{short}{a string with a short name for given metadata field}

\item{trim.white}{a logical value indicating whether trailing and leading spaces of the given string should be removed before extraction}

\item{mandatory}{a logical value indicating required field}

\item{default.value}{fallback to this value if non-mandatory field is not found/malformed}

\item{field.length}{maximum number of field characters (defaults to 1000)}

\item{...}{additional parameters for \code{grepl} function}
}
\value{
a list with matched content, or \code{NULL} if the field is not required
}
\description{
Check if template metadata field matches provided format, and return matched value in a list.
}
\examples{
\dontrun{
    rapport:::extract.meta("Name: John Smith", "Name", "[[:alpha:]]+( [[:alpha:]]+)?")
    ## $name
    ## [1] "John Smith"

    rapport:::extract.meta("Name: John", "Name", "[[:alpha:]]+( [[:alpha:]]+)?")
    ## $name
    ## [1] "John"
}
}
