#' Estimate string width
#'
#' Pre-computed width of strings without actually calling to \pkg{graphics} and \code{new.plot}. The function can only handle base ASCII characters and default width of those is estimated by using standard 12 pt \code{serif} on a standard \code{plot}. Non-ASCII characters are replaced by an underscore.
#' @return numeric value representing the total width of the provided string in millimeters
#' @param s string
#' @export
#' @examples \dontrun{
#' strwidthrel('R') # 71
#' strwidthrel('R is awesome!') # 635
#' }
strwidthest <- function(s) {

    ## computed by the following R command
    ######################################
    ## df <- as.data.frame(do.call(rbind, lapply(32:126, function(i) c(
    ##     id    = i,
    ##     char  = rawToChar(as.raw(i)),
    ##     width = strwidth(rawToChar(as.raw(i)), units = 'inches') * 25.5
    ## ))), stringsAsFactors = FALSE)
    ## df$width <- as.numeric(df$width)

    df <- structure(list(id = c("32", "33", "34", "35", "36", "37", "38",
                             "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
                             "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60",
                             "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71",
                             "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82",
                             "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93",
                             "94", "95", "96", "97", "98", "99", "100", "101", "102", "103",
                             "104", "105", "106", "107", "108", "109", "110", "111", "112",
                             "113", "114", "115", "116", "117", "118", "119", "120", "121",
                             "122", "123", "124", "125", "126"),
                         char = c(" ", "!", "\"",
                             "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/",
                             "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<",
                             "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I",
                             "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V",
                             "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b",
                             "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o",
                             "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|",
                             "}", "~"),
                         width = c(1.32707923228346, 1.32707923228346, 1.59249507874016,
                             2.38874261811024, 2.38874261811024, 3.7158218503937, 2.91957431102362,
                             0.796247539370079, 1.59249507874016, 1.59249507874016, 1.59249507874016,
                             2.65415846456693, 1.06166338582677, 1.32707923228346, 1.06166338582677,
                             1.32707923228346, 2.38874261811024, 2.38874261811024, 2.38874261811024,
                             2.38874261811024, 2.38874261811024, 2.38874261811024, 2.38874261811024,
                             2.38874261811024, 2.38874261811024, 2.38874261811024, 1.06166338582677,
                             1.06166338582677, 2.65415846456693, 2.65415846456693, 2.65415846456693,
                             2.38874261811024, 4.51206938976378, 2.91957431102362, 2.91957431102362,
                             3.18499015748031, 3.18499015748031, 2.91957431102362, 2.65415846456693,
                             3.45040600393701, 3.18499015748031, 1.06166338582677, 2.12332677165354,
                             2.91957431102362, 2.38874261811024, 3.45040600393701, 3.18499015748031,
                             3.45040600393701, 2.91957431102362, 3.45040600393701, 3.18499015748031,
                             2.91957431102362, 2.65415846456693, 3.18499015748031, 2.91957431102362,
                             3.98123769685039, 2.91957431102362, 2.91957431102362, 2.65415846456693,
                             1.32707923228346, 1.32707923228346, 1.32707923228346, 2.12332677165354,
                             2.38874261811024, 1.59249507874016, 2.38874261811024, 2.38874261811024,
                             2.12332677165354, 2.38874261811024, 2.38874261811024, 1.32707923228346,
                             2.38874261811024, 2.38874261811024, 0.796247539370079, 1.06166338582677,
                             2.12332677165354, 0.796247539370079, 3.7158218503937, 2.38874261811024,
                             2.38874261811024, 2.38874261811024, 2.38874261811024, 1.32707923228346,
                             2.12332677165354, 1.32707923228346, 2.38874261811024, 2.12332677165354,
                             3.18499015748031, 2.12332677165354, 2.12332677165354, 2.12332677165354,
                             1.59249507874016, 1.06166338582677, 1.59249507874016, 2.65415846456693
                                   )),
                    .Names = c("id", "char", "width"),
                    row.names = c(NA, -95L), class = "data.frame")

    ## split string
    ids <- as.integer(charToRaw(s))

    ## handle NAs
    w <- which(!ids %in% df$id)
    if (length(w) > 0)
        ids[w] <- 53

    ## match from look-up tables
    sum(df$width[match(ids, df$id)])

}
