% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/SpatialPolygons2PolySet.R
\name{SpatialPolygons2PolySet}
\alias{SpatialPolygons2PolySet}
\alias{SpatialPolygons2PolySet.SpatialPolygons}
\alias{SpatialPolygons2PolySet.SpatialPolygonsDataFrame}
\title{Convert SpatialPolygons to PolySet data}
\usage{
SpatialPolygons2PolySet(x, n_preallocate)

\method{SpatialPolygons2PolySet}{SpatialPolygonsDataFrame}(x,
  n_preallocate = 10000L)

\method{SpatialPolygons2PolySet}{SpatialPolygons}(x, n_preallocate = 10000L)
}
\arguments{
\item{x}{\code{SpatialPolygons} or \code{SpatialPolygonsDataFrame} object.}

\item{n_preallocate}{\code{integer} How much memory should be preallocated for processing? Ideally, this number should equal the number of vertices in the \code{SpatialPolygons} object. If data processing is taking too long consider increasing this value.}
}
\value{
\code{PolySet} object.
}
\description{
This function converts spatial \code{SpatialPolygons} and \code{SpatialPolygonsDataFrame} objects to \code{PolySet} objects.
}
\note{
Be aware that this function is designed to be as fast as possible, but as a result it depends on C++ code and if used inappropriately this function will crash R.
}
\examples{
# generate SpatialPolygons object
sim_pus <- sim.pus(225L)
# convert to PolySet
x <- SpatialPolygons2PolySet(sim_pus)
}
\seealso{
For a slower, more stable equivalent see \code{maptools::SpatialPolygons2PolySet}.
}

