% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapResults.R, R/RapSolved.R
\name{logging.file}
\alias{logging.file}
\alias{logging.file.RapResults}
\alias{logging.file.RapSolved}
\title{Log file}
\usage{
logging.file(x, y)

\method{logging.file}{RapResults}(x, y = 0)

\method{logging.file}{RapSolved}(x, y = 0)
}
\arguments{
\item{x}{\code{\link{RapResults}} or \code{\link{RapSolved}} object.}

\item{y}{Available inputs include: \code{NULL} to return all values,
\code{integer} number specifying the solution for which the log file should
be returned, and \code{0} to return log file for the best solution.}
}
\description{
This function returns the Gurobi log file (*.log) associated with solving
an optimization problem.
}
\note{
The term logging file was used due to collisions with the \code{log}
  function.
}
\examples{
# load data
data(sim_rs)

# log file for the best solution
cat(logging.file(sim_rs, 0))

# log file for the second solution
cat(logging.file(sim_rs, 2))

# log files for all solutions
cat(logging.file(sim_rs, NULL))

}
\seealso{
\code{\link{RapResults}}, \code{\link{RapSolved}}.
}
