% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/calcSpeciesAverageInPus.R
\name{calcSpeciesAverageInPus}
\alias{calcSpeciesAverageInPus}
\alias{calcSpeciesAverageInPus.SpatialPolygons}
\alias{calcSpeciesAverageInPus.SpatialPolygonsDataFrame}
\title{Calculate average value for species data in planning units}
\usage{
calcSpeciesAverageInPus(x, ...)

\method{calcSpeciesAverageInPus}{SpatialPolygons}(x, y, ids = seq_len(nlayers(y)), ncores = 1, ...)

\method{calcSpeciesAverageInPus}{SpatialPolygonsDataFrame}(
  x,
  y,
  ids = seq_len(nlayers(y)),
  ncores = 1,
  field = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link[sp:SpatialPolygons]{sp::SpatialPolygons()}} or
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} object.}

\item{...}{not used.}

\item{y}{\code{\link[raster:raster]{raster::raster()}},
\code{\link[raster:stack]{raster::stack()}}, or
\code{\link[raster:brick]{raster::brick()}} object.}

\item{ids}{\code{integer} vector of ids. Defaults to indices of layers in
argument to \code{y}.}

\item{ncores}{\code{integer} number of cores to use for processing. Defaults
to 1.}

\item{field}{\code{integer} index or \code{character} name of column with
planning unit ids. Valid only when \code{x} is a
\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} object. Default behavior is to
treat each polygon as a different planning unit.}
}
\value{
\code{\link[base:data.frame]{base::data.frame()}} with sum of raster values in each
polygon.
}
\description{
This function calculates the average of species values in each planning unit.
By default all polygons will be treated as having separate ids.
}
\examples{
# simulate data
sim_pus <- sim.pus(225L)
sim_spp <- lapply(c("uniform", "normal", "bimodal"), sim.species, n = 1,
                  res = 1, x = sim_pus)

# calculate average for 1 species
puvspr1.dat <- calcSpeciesAverageInPus(sim_pus, sim_spp[[1]])

# calculate average for multiple species
puvspr2.dat <- calcSpeciesAverageInPus(sim_pus, stack(sim_spp))

}
