% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ES.R
\name{es}
\alias{es}
\title{Calculate the Expected Species}
\usage{
es(x, m, method = c("a", "b"), MARGIN = 1)
}
\arguments{
\item{x}{a data vector representing number of individuals for each species}

\item{m}{the sample size parameter that represents the number of individuals randomly drawn from the sample, which by default is set to m=1, but can be changed according to the users' requirements. For ESa, m can not be larger than the sample size}

\item{method}{the calculation approach of Expected Species used, with two options available as "a" and "b" to calculate ESa and ESb, with the default set as "a"}

\item{MARGIN}{a vector giving the subscripts which the function will be applied over, see '\link[base]{apply}'.}
}
\value{
a value of Expected Species
}
\description{
Calculate the Expected Species
}
\examples{
data(share, package = 'rarestR')
rowSums(share) #The sum size of each sample is 100, 150 and 200
es(share, m = 100)
es(share, method = "b", m = 100)
# When the m is larger than the total sample size, "NA" will be filled:
es(share, m = 150)
}
