% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{rasciidoc}
\alias{rasciidoc}
\title{Render an \command{asciidoc} File}
\usage{
rasciidoc(
  file_name,
  ...,
  write_to_disk = getOption("write_to_disk"),
  enforce_requirements = getOption("enforce_requirements")
)
}
\arguments{
\item{file_name}{The file to run \command{asciidoc} on.}

\item{...}{arguments passed to \command{asciidoc} via \code{\link{system2}}.}

\item{write_to_disk}{Write to disk? See \bold{Warning}.}

\item{enforce_requirements}{Should system requirements be enforced (CRAN
requires packages to pass checks if system requirements (external commands)
are not met)? Set to \code{\link{TRUE}} to enforce.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}} or
\code{\link{FALSE}}, depending on success.
}
\description{
This is the basic interface to \command{asciidoc}. Not more than a call to
\code{\link{system2}} and checks on \command{asciidoc} and
\command{source-highlight}.
You should usually not call it directly, see
\code{\link{render}} for a wrapper.
}
\section{Warning}{

Due to the CRAN policy of not writing "anywhere else on the
file system apart from the R session's temporary directory",
we work on a temporary copy of \code{file_name}.
Thus all internal sourcing and internal links will be
broken and any output is written to \code{tempdir()}.
Set the option "write_to_disk" to TRUE (using \cr
\code{options(write_to_disk = TRUE)}\cr
to bypass this. You may want to include the above line into your ~/.Rprofile.
}

\examples{
# CRAN complains about elapsed times
if (fritools::is_running_on_fvafrcu_machines()) {
    wd <- file.path(tempdir(), "rasciidoc")
    dir.create(wd)
    file  <- system.file("files", "minimal", "knit.asciidoc",
                         package = "rasciidoc")
    file.copy(file, wd)
    rasciidoc::rasciidoc(file_name = file.path(wd, basename(file)),
                         write_to_disk = getOption("write_to_disk"),
                         "-b html")
    if (isTRUE(getOption("write_to_disk"))) {
        dir(wd, full.names = TRUE)
    } else {
        dir(tempdir(), full.names = TRUE)
    }
    unlink(wd, recursive = TRUE)
}
}
\seealso{
\code{\link{render}}
}
