% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RenyiS.R
\name{RenyiS}
\alias{RenyiS}
\title{Sequential Renyi's diversity index}
\usage{
RenyiS(
  x,
  window = 1,
  alpha = 1,
  base = exp(1),
  na.tolerance = 1,
  debugging = FALSE
)
}
\arguments{
\item{x}{A numeric matrix representing the data on which the index is to be calculated.}

\item{window}{The width of the moving window to consider for each cell. The actual window size 
will be `(2 * window + 1) x (2 * window + 1)`. Default is 1.}

\item{alpha}{(Not used in this function, included for compatibility) The alpha parameter for 
diversity indices, default is 1.}

\item{base}{The base of the logarithm used in the Shannon formula, default is `exp(1)` (natural logarithm).}

\item{na.tolerance}{The tolerance level for missing data within the moving window. 
A window will be processed only if the proportion of non-missing data is above this threshold. 
Value should be between 0 and 1. Default is 1.}

\item{debugging}{Boolean flag to enable or disable debugging messages. Default is FALSE.}
}
\value{
A matrix of the same dimensions as `x`, where each cell contains the 
        Renyi's diversity index calculated for the window around the cell.
}
\description{
This function calculates the Renyi's diversity index index for each cell in a matrix,
considering a specified moving window around each cell.
}
\details{
Berger-Parker's diversity index calculated sequentially over a raster matrix.
}
\examples{
data <- matrix(runif(100), nrow = 10)
renyi_index <- RenyiS(data, window = 1)

}
