% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMCMC.R
\name{readMCMC}
\alias{readMCMC}
\title{Read the MCMC output files}
\usage{
readMCMC(handle, burn = 0.25, thin = 100, dir = NULL)
}
\arguments{
\item{handle}{the output object from the 'ratematrixMCMC' function.}

\item{burn}{the proportion of the burnin to be pruned from the MCMC chain. A number between 0 and 1 (default is 0.25).}

\item{thin}{the thinning of the posterior distribution. A number with the interval between each MCMC step to be kept in the posterior distribution (default is 100).}

\item{dir}{directory with the output files. If 'NULL' (default), then files are read from the directory chosen when running the MCMC chain using the argument 'dir' of the 'ratematrixMCMC' function (stored on handle). Otherwise function will read files from 'dir'.}
}
\value{
List with the MCMC chain for the phylogenetic mean (root value) and evolutionary rate matrices (R). *root* are the values for the phylogenetic mean in matrix format; *matrix* is a list of length equal to the number of rate regimes fitted to the tree, each of those are lists with the chain of respective R matrices.
}
\description{
Reads the output files from the MCMC with the posterior distribution of the chains.
}
\examples{
\donttest{
## Load data
data(centrarchidae)
## Run MCMC. This is just a very short chain.
handle <- ratematrixMCMC(data=centrarchidae$data, phy=centrarchidae$phy.map, gen=1000
                         , dir=tempdir())
## Load posterior distribution, make plots and check the log.
posterior <- readMCMC(handle, burn=0.25, thin=1)
plotRatematrix(posterior)
plotRootValue(posterior)
plotPrior(handle)
plotPrior(handle, root=TRUE)
logAnalyzer(handle)
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
