% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoodFunction.R
\name{likelihoodFunction}
\alias{likelihoodFunction}
\title{Likelihood function for the multivariate Brownian motion model}
\usage{
likelihoodFunction(data, phy, root, R)
}
\arguments{
\item{data}{a matrix with the data. Species names need to be provided as rownames (rownames(data) == phy$tip.label).}

\item{phy}{a phylogeny of the class "simmap" with the mapped regimes or "phylo" for a single rate model.}

\item{root}{a numeric vector with the root value (phylogenetic mean).}

\item{R}{a matrix or a list of matrices. If 'R' is a matrix then the likelihood for a single regime is calculated. If 'R' is a list of matrices, then each matrix will be fitted to a regime in 'phy' and the length of the list need to match the number of regimes fitted to the tree.}
}
\value{
The log likelihood for the multivariate Brownian motion model.
}
\description{
Returns the log-likelihood for the multivariate Brownian motion model with 1 or more rate regimes mapped to the tree.
}
\details{
If two or more rate regimes are mapped to the phylogenetic tree, then the function calculates the likelihood using the new prunning algorithm adapted to fit multiple rate regimes. The prunning algorithm is implemented in C++ using 'Rcpp' and 'RcppArmadillo'. Otherwise the function uses the three point algorithm (Ho and Ané, 2014) to make calculations for the single regime case.
}
\examples{
\donttest{
data( centrarchidae )
root <- colMeans( centrarchidae$data )
Rlist <- list( rbind(c(0.5, 0.1),c(0.1,0.5)), rbind(c(0.5, 0),c(0,0.5)) )
likelihoodFunction(data = centrarchidae$data, phy = centrarchidae$phy.map, root = root
                   , R = Rlist)
## Get the likelihood for a single regime model:
phy.single <- mergeSimmap(phy = centrarchidae$phy.map, drop.regimes = TRUE)
Rsingle <- rbind(c(0.5, 0.1),c(0.1,0.5))
likelihoodFunction(data = centrarchidae$data, phy = phy.single, root = root, R = Rsingle)
}
}
\references{
\describe{
  \item{}{Ho, L. S. T. and Ané, C. (2014). "A linear-time algorithm for Gaussian and non-Gaussian trait evolution models". Systematic Biology *63*(3):397-408.}
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
