% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPrior.R
\name{plotPrior}
\alias{plotPrior}
\title{Plot the prior distribution used in the MCMC analysis}
\usage{
plotPrior(handle, n = 1000, root = FALSE, color = "black", ...)
}
\arguments{
\item{handle}{the output object from the 'ratematrixMCMC' function.}

\item{n}{number of samples from the prior to be plotted (default is 1000).}

\item{root}{whether to plot the prior for the root value instead of the evolutionary rate matrix (default is FALSE).}

\item{color}{color for the plot (default is "black").}

\item{...}{other parameters to be passed to the function 'plotRatematrix' or 'plotRootValue'. See help page for list of possible parameters.}
}
\value{
A plot similar to 'plotRatematrix'.
}
\description{
Function plots the prior distribution used in the MCMC analysis.
}
\details{
Function will make a plot of the prior for the evolutionary rate matrix by default. One can plot the prior for the root value instead by setting 'root' to TRUE. \cr
\cr
The prior distribution often has a different range of parameter values when compared to the posterior distribution. Depending on the prior configuration the range of the prior can be orders of magnitude larger than the posterior distribution. In this case, it is important to observe the scale of the x axis when comparing the prior and the posterior distribution. One can use the 'set.xlim' parameter to restrict the x axis for plotting the prior to be similar to the posterior distribution. However, often the region of parameter space of the posterior distribution has a low likelihood under the prior. This results in problems to take samples from that region to make the plot. This problem can be identified when the 'set.xlim' argument is changed and the plot shows only a few samples. \cr
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
