% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreci.R
\name{scoreci}
\alias{scoreci}
\title{Score confidence intervals for comparisons of independent binomial or Poisson
rates.}
\usage{
scoreci(x1, n1, x2 = NULL, n2 = NULL, distrib = "bin", contrast = "RD",
  level = 0.95, skew = TRUE, bcf = TRUE, cc = 0, delta = NULL,
  precis = 6, plot = FALSE, plotmax = 100, stratified = FALSE,
  weighting = "IVS", wt = NULL, tdas = FALSE, ...)
}
\arguments{
\item{x1, x2}{Numeric vectors of numbers of events in group 1 & group 2 
respectively.}

\item{n1, n2}{Numeric vectors of sample sizes (for binomial rates) or exposure
times (for Poisson rates) in each group.}

\item{distrib}{Character string indicating distribution assumed for the input
data: "bin" = binomial (default), "poi" = Poisson.}

\item{contrast}{Character string indicating the contrast of interest: "RD" = 
rate difference (default), "RR" = rate ratio, "OR" = odds ratio, "p" =
single proportion.}

\item{level}{Number specifying confidence level (between 0 and 1, default 
0.95).}

\item{skew}{Logical (default TRUE) indicating whether to apply skewness
correction (Laud 2016).}

\item{bcf}{Logical (default TRUE) indicating whether to apply bias correction in the score 
denominator. Applicable to distrib = "bin" only. (NB: bcf = FALSE option is
really only included for legacy validation against previous published 
methods (i.e. Gart & Nam, Mee).}

\item{cc}{Number or logical (default FALSE) specifying (amount of) continuity
correction.}

\item{delta}{Number to be used in a one-sided significance test (e.g. 
non-inferiority margin). 1-sided p-value will be <0.025 iff 2-sided 95\% CI
excludes delta. NB: can also be used for a superiority test by setting 
delta=0.}

\item{precis}{Number (default 6) specifying precision to be used in
optimisation subroutine (i.e. number of decimal places).}

\item{plot}{Logical (default FALSE) indicating whether to output plot of the
score function}

\item{plotmax}{Numeric value indicating maximum value to be displayed on 
x-axis of plots (useful for ratio contrasts which can be infinite).}

\item{stratified}{Logical (default FALSE) indicating whether to combine
vector inputs into a single stratified analysis.}

\item{weighting}{String indicating which weighting method to use if 
stratified = "TRUE":  "IVS" = Inverse Variance of Score (default), "MH" = 
Mantel-Haenszel, "MN" = Miettinen-Nurminen iterative weights.}

\item{wt}{Numeric vector containing (optional) user-specified weights.}

\item{tdas}{Logical (default FALSE) indicating whether to use t-distribution
method for stratified data (defined in Laud 2016).}

\item{...}{Other arguments.}
}
\value{
A list containing the following components: \describe{ 
  \item{estimates}{a matrix containing estimates of the rates in each group 
  and of the requested contrast, with its confidence interval} \item{pval}{a 
  matrix containing details of the corresponding 2-sided significance test 
  against the null hypothesis that p_1 = p_2, and one-sided significance 
  tests agains the null hypothesis that theta >= or <= delta} 
  \item{call}{details of the function call} }
  If stratified = TRUE, the following outputs are added: \describe{
  \item{Qtest}{a vector of values descibing and testing heterogeneity}
  \item{weighting}{a string indicating the selected weighting method}
  \item{stratdata}{a matrix containing stratum estimates and weights}}
}
\description{
Score-based confidence intervals for the rate (or risk) difference ("RD") or 
ratio ("RR") for independent binomial or Poisson rates, or for odds ratio 
("OR", binomial only). Including options for bias correction (from Miettinen 
& Nurminen), skewness correction ("GNbc" method from Laud & Dane, developed
from Gart & Nam, and generalised as "SCAS" in forthcoming publication) and
continuity correction. Also includes intervals for a single proportion, i.e.
Wilson score method, with skewness correction, which has slightly better
coverage properties than the Jeffreys method. This function is vectorised in
x1, x2, n1, and n2.  Vector inputs may also be combined into a single
stratified analysis (e.g. meta-analysis), either using fixed effects, or the
more general "TDAS" method, which incorporates stratum variability using a
t-distribution score (inspired by to Hartung-Knapp-Sidik-Jonkman).
}
\examples{
 
  #Binomial RD, SCAS method:
  scoreci(x1 = c(12,19,5), n1 = c(16,29,56), x2 = c(1,22,0), n2 = c(16,30,29))
  
  #Binomial RD, MN method:
  scoreci(x1 = c(12,19,5), n1 = c(16,29,56), x2 = c(1,22,0), n2 = c(16,30,29), skew = FALSE)
  
  #Poisson RR, SCAS method:
  scoreci(x1 = 5, n1 = 56, x2 = 0, n2 = 29, distrib = "poi", contrast = "RR")
  
  #Poisson RR, MN method:
  scoreci(x1 = 5, n1 = 56, x2 = 0, n2 = 29, distrib = "poi", contrast = "RR", skew = FALSE)
  
  #Binomial rate, SCAS method:
  scoreci(x1 = c(5,0), n1 = c(56,29), contrast = "p")
  
  #Binomial rate, Wilson score method:
  scoreci(x1 = c(5,0), n1 = c(56,29), contrast = "p", skew = FALSE)
  
  #Poisson rate, SCAS method:
  scoreci(x1 = c(5,0), n1 = c(56,29), distrib = "poi", contrast = "p")

  #Stratified example, using data from Hartung & Knapp:
  scoreci(x1 = c(15,12,29,42,14,44,14,29,10,17,38,19,21),
          x2 = c(9,1,18,31,6,17,7,23,3,6,12,22,19),
          n1 = c(16,16,34,56,22,54,17,58,14,26,44,29,38),
          n2 = c(16,16,34,56,22,55,15,58,15,27,45,30,38),
          stratified = TRUE)
          
  #TDAS example, using data from Hartung & Knapp:
  scoreci(x1 = c(15,12,29,42,14,44,14,29,10,17,38,19,21),
          x2 = c(9,1,18,31,6,17,7,23,3,6,12,22,19),
          n1 = c(16,16,34,56,22,54,17,58,14,26,44,29,38),
          n2 = c(16,16,34,56,22,55,15,58,15,27,45,30,38),
          stratified = TRUE, tdas = TRUE)

}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
\references{
Laud PJ. Equal-tailed confidence intervals for comparison of 
  rates: Submitted to Pharmaceutical Statistics for peer review.
  
  Laud PJ, Dane A. Confidence intervals for the difference between independent 
  binomial proportions: comparison using a graphical approach and
  moving averages. Pharmaceutical Statistics 2014; 13(5):294–308
  
  Miettinen OS, Nurminen M. Comparative analysis of two rates. Statistics in 
  Medicine 1985; 4:213-226.
  
  Farrington CP, Manning G. Test statistics and sample size formulae for 
  comparative binomial trials with null hypothesis of non-zero risk 
  difference or non-unity relative risk. Statistics in Medicine 1990; 
  9(12):1447-1454.
  
  Gart JJ, Nam Jm. Approximate interval estimation of the ratio of binomial 
  parameters: A review and corrections for skewness. Biometrics 1988; 
  44(2):323-338.
  
  Gart JJ, Nam Jm. Approximate interval estimation of the difference in 
  binomial parameters: correction for skewness and extension to multiple 
  tables. Biometrics 1990; 46(3):637-643.
}

