% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairbinci.R
\name{pairbinci}
\alias{pairbinci}
\title{Confidence intervals for comparisons of paired binomial rates.}
\usage{
pairbinci(x, contrast = "RD", level = 0.95, method_RD = "Score",
  method_RR = "Score", method_OR = "SCAS", theta0 = NULL, precis = 6)
}
\arguments{
\item{x}{A numeric vector object specified as c(a,b,c,d)
where:
a is the number of pairs with the event (e.g. success) under both
  conditions (e.g. treated/untreated, or case/control)
b is the count of the number with the event on condition 1 only (=n12)
c is the count of the number with the event on condition 2 only (=n21)
d is the number of pairs with no event under both conditions
(Note the order of a and d is only important for contrast="RR".)}

\item{contrast}{Character string indicating the contrast of interest:
"RD" = rate difference (default), "RR" = rate ratio, "OR" = odds ratio.}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{method_RD}{Character string indicating the confidence interval method
to be used for contrast="RD". "Score" = Tango asymptotic score (default),
"TDAS" = t-distribution asymptotic score (experimental method, seems to
struggle with low numbers).}

\item{method_RR}{Character string indicating the confidence interval method
to be used for contrast="RR". "Score" = Tang asymptotic score (default),
"TDAS" t-distribution asymptotic score (experimental method, seems to
struggle with low numbers).}

\item{method_OR}{Character string indicating the confidence interval method
to be used for contrast="OR", all of which are based on transformation of
an interval for a single proportion b/(b+c):
"SCAS" = transformed skewness-corrected score (default),
"Jeffreys" = transformed Jeffreys (to be added),
"midp" = transformed mid-p,
("Wilson" = transformed Wilson score - not yet included, would be for
reference only, not recommended).}

\item{theta0}{Number to be used in a one-sided significance test (e.g.
non-inferiority margin). 1-sided p-value will be <0.025 iff 2-sided 95\% CI
excludes theta0. NB: can also be used for a superiority test by setting
theta0=0.}

\item{precis}{Number (default 6) specifying precision (i.e. number of decimal
places) to be used in optimisation subroutine for the confidence interval.}
}
\description{
Score-based confidence intervals for the rate (or risk) difference ('RD'),
rate ratio ('RR') or odds ratio ('OR'), for paired binomial data.
[For paired Poisson rates, use the tdasci function with distrib='poi',
and weighting='MH', with pairs as strata.].
This function applies the Tango and Tang methods for RD and RR respectively,
as well as an experimental method using the stratified TDAS method with
pairs as strata.
For OR, intervals are produced based on transforming various intervals for
the single proportion, including SCAS, mid-p and Jeffreys.
}
\examples{
  #Data example from Agresti-Min 2005
  pairbinci(x = c(53,16,8,9), contrast="RD", method_RD="Score")
  pairbinci(x = c(53,16,8,9), contrast="RD", method_RD="TDAS")
  pairbinci(x = c(53,16,8,9), contrast="RR", method_RR="Score")
  pairbinci(x = c(53,16,8,9), contrast="RR", method_RR="TDAS")
  pairbinci(x = c(53,16,8,9), contrast="OR", method_OR="SCAS")
}
\references{
Laud PJ. Equal-tailed confidence intervals for comparison of
  rates. Pharmaceutical Statistics 2017; 16:334-348.

  Tango T. Equivalence test and confidence interval for the difference
  in proportions for the paired-sample design. Statistics in Medicine
  1998; 17:891-908

  Tango T. Improved confidence intervals for the difference between binomial
  proportions based on paired data by Robert G. Newcombe, Statistics in
  Medicine, 17, 2635–2650 (1998). Statistics in Medicine 1999;
  18(24):3511-3513

  Tang N-S, Tang M-L, Chan ISF. On tests of equivalence via non-unity
  relative risk for matched-pair design. Statistics in Medicine 2003;
  22:1217-1233

  Fagerland MW, Lydersen S, Laake P. Recommended tests and
  confidence intervals for paired binomial proportions. Statistics in
  Medicine 2014; 33(16):2850–2875

  Agresti A, Min Y. Simple improved confidence intervals for
  comparing matched proportions. Statistics in Medicine 2005;
  24:729-740
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
