# SCCS @(#)survexp.wnc.s	4.3 06/07/96
#
# Create the WNC hazards table
#   The raw numbers below are q* 10^5.  Note that there are 24 leap years/100
#
survexp.wnc  <- {
    temp <- c(
      7702,1617,2011,899,559,401,508,430,368,316,279,257,246,247,260,281,284,
      315,353,399,442,489,525,539,542,548,476,484,500,520,542,565,593,626,658,
      690,645,673,696,718,739,765,792,821,856,891,947,988,1028,1066,1104,1140,
      1189,1254,1339,1431,1643,1769,1894,2013,2139,2275,2417,2574,2742,2911,
      3639,3867,4106,4365,4636,4918,5221,5558,5914,6283,8302,8908,9474,10011,
      10606,11279,11914,12411,12686,12875,15759,17203,18714,20308,21961,23607,
      25190,26793,28417,30025,31418,32853,34502,36011,37674,39551,40740,41666,
      46428,46666,49999,49999,49999,49999,49999,6299,1278,1847,811,526,381,448,
      371,310,261,226,206,199,201,218,235,235,260,288,313,342,370,395,414,428,
      443,446,460,473,485,499,513,529,546,567,584,582,598,611,623,636,652,669,
      696,725,759,816,856,898,936,980,1026,1079,1148,1232,1328,1303,1409,1512,
      1609,1714,1821,1940,2133,2181,2386,2787,2975,3181,3409,3646,3904,4158,
      4396,4612,4830,7263,7741,8262,8846,9495,10253,10968,11452,11680,11824,
      13150,14909,16734,18584,20476,22407,24382,26328,28205,29927,31410,32891,
      34506,36041,37499,39344,41080,42201,44444,45713,47368,49999,49999,49999,
      49999,5840,1103,1102,632,444,373,312,263,257,226,202,192,188,216,235,258,
      291,333,363,386,403,417,434,450,466,481,492,505,553,564,579,598,618,625,
      648,668,685,703,647,657,669,689,712,699,735,770,797,828,874,913,963,1021,
      1093,1193,1272,1362,1464,1576,1726,1879,2036,2176,2324,2528,2700,2891,
      3109,3368,3756,4097,4467,4863,5266,5781,6217,6668,7130,7597,8759,9362,
      10000,10699,11456,15226,16821,18609,15759,17203,18714,20308,21961,23607,
      25190,26793,28417,30025,31418,32853,34502,36011,37674,39551,40740,41666,
      46428,46666,49999,49999,49999,49999,49999,4481,873,975,555,400,327,269,
      222,230,197,180,168,165,180,194,217,245,281,320,358,393,427,459,524,548,
      563,584,600,636,645,654,663,673,660,670,679,684,690,659,664,670,682,698,
      674,704,738,771,809,819,864,913,970,1032,1126,1196,1271,1365,1467,1511,
      1647,1779,1907,2041,2146,2299,2478,2681,2916,3265,3572,3895,4230,4577,
      5291,5703,6132,6584,7048,8032,8612,9224,9885,10586,12208,13088,13941,
      13150,14909,16734,18584,20476,22407,24382,26328,28205,29927,31410,32891,
      34506,36041,37499,39344,41080,42201,44444,45713,47368,49999,49999,49999,
      49999,4776,774,823,430,297,256,250,215,185,162,147,138,141,148,161,179,
      213,241,267,285,301,318,338,353,361,366,333,336,343,351,361,369,383,395,
      414,436,428,449,472,499,532,568,607,646,687,727,784,833,887,942,1005,1071,
      1140,1216,1303,1399,1526,1643,1772,1907,2042,2177,2326,2488,2674,2874,
      3434,3709,4012,4330,4660,5000,5352,5710,6094,6507,7753,8361,9017,9716,
      10415,11098,11737,12306,12777,13111,15759,17203,18714,20308,21961,23607,
      25190,26793,28417,30025,31418,32853,34502,36011,37674,39551,40740,41666,
      46428,46666,49999,49999,49999,49999,49999,3596,636,708,367,262,215,219,
      183,153,131,121,113,112,119,131,144,144,163,182,203,223,242,264,281,290,
      292,328,332,336,343,354,362,372,382,394,406,415,430,444,463,485,510,538,
      568,600,635,621,658,698,743,791,843,899,961,1031,1112,1204,1313,1422,1531,
      1653,1787,1929,2084,2258,2451,2730,2970,3234,3518,3820,4137,4470,4819,
      5190,5592,7046,7680,8376,9130,9925,10726,11534,12313,13042,13696,13150,
      14909,16734,18584,20476,22407,24382,26328,28205,29927,31410,32891,34506,
      36041,37499,39344,41080,42201,44444,45713,47368,49999,49999,49999,49999,
      3800,472,414,244,177,124,117,111,105,101,97,96,98,102,110,121,134,148,160,
      170,182,193,202,210,214,217,217,219,223,228,233,239,248,258,271,286,302,
      320,341,364,389,417,446,478,511,549,591,639,692,751,821,895,977,1069,1167,
      1273,1385,1505,1632,1765,1907,2060,2227,2406,2604,2821,3063,3337,3643,
      3987,4370,4793,5255,5759,6303,6892,7532,8222,8976,9792,10677,11637,12677,
      13801,15020,16315,15759,17203,18714,20308,21961,23607,25190,26793,28417,
      30025,31418,32853,34502,36011,37674,39551,40740,41666,46428,46666,49999,
      49999,49999,49999,49999,2963,418,351,195,128,110,98,88,79,74,71,69,69,70,
      75,80,89,97,105,112,121,130,138,144,151,156,161,165,173,180,188,196,203,
      213,221,231,242,255,267,283,298,318,336,362,386,414,442,475,510,548,587,
      633,682,736,795,864,936,1017,1104,1200,1307,1424,1555,1701,1864,2048,2253,
      2481,2736,3022,3341,3697,4094,4536,5026,5567,6163,6811,7515,8276,9104,
      9995,10963,12006,13130,14330,13150,14909,16734,18584,20476,22407,24382,
      26328,28205,29927,31410,32891,34506,36041,37499,39344,41080,42201,44444,
      45713,47368,49999,49999,49999,49999,2644,227,205,131,98,90,81,75,67,64,63,
      62,68,73,84,100,117,134,146,154,160,164,166,168,169,167,163,163,164,165,
      167,173,180,187,200,211,225,243,263,284,307,333,363,399,441,488,539,594,
      652,711,772,835,909,993,1084,1186,1295,1416,1545,1684,1832,1991,2164,2351,
      2547,2754,2976,3224,3505,3812,4141,4502,4903,5356,5860,6400,6992,7635,
      8342,9107,9919,10794,11735,12762,13881,15091,15759,17203,18714,20308,
      21961,23607,25190,26793,28417,30025,31418,32853,34502,36011,37674,39551,
      40740,41666,46428,46666,49999,49999,49999,49999,49999,1977,197,167,108,85,
      65,57,49,46,43,42,41,41,43,45,48,54,57,61,64,67,70,72,76,77,78,79,81,84,
      86,92,96,102,109,118,128,140,152,166,180,194,209,226,246,267,293,319,347,
      378,410,442,477,517,562,612,666,724,791,866,948,1035,1134,1242,1367,1500,
      1643,1801,1984,2208,2460,2738,3049,3400,3799,4240,4721,5246,5824,6465,
      7153,7892,8689,9560,10518,11586,12748,13150,14909,16734,18584,20476,22407,
      24382,26328,28205,29927,31410,32891,34506,36041,37499,39344,41080,42201,
      44444,45713,47368,49999,49999,49999,49999,2317,146,151,102,77,66,62,59,56,
      52,47,43,42,48,62,81,103,123,141,154,163,172,180,184,180,172,161,152,146,
      146,149,155,160,167,173,181,190,203,220,240,265,294,326,362,401,445,491,
      543,604,674,753,840,932,1022,1110,1197,1287,1388,1508,1652,1818,1998,2186,
      2381,2581,2790,3011,3250,3506,3782,4081,4398,4741,5125,5562,6053,6592,
      7177,7823,8538,9330,10252,11293,12373,13416,14417,15756,17202,18716,20309,
      21967,23603,25191,26795,28430,30017,31416,32915,34450,36018,37616,39242,
      40891,42562,44250,45951,47662,49378,51095,52810,54519,1722,128,132,77,61,
      47,42,38,35,32,30,29,29,31,34,39,45,51,55,57,57,57,57,58,59,61,63,65,68,
      72,77,82,89,95,100,106,112,120,129,140,153,166,182,199,220,242,267,293,
      321,349,379,413,449,484,517,549,583,625,681,754,843,944,1052,1163,1275,
      1392,1519,1663,1834,2036,2269,2523,2799,3116,3480,3893,4336,4816,5373,
      6028,6782,7653,8612,9604,10572,11531,13150,14912,16732,18587,20474,22409,
      24382,26331,28200,29919,31416,32915,34450,36018,37616,39242,40891,42562,
      44250,45951,47662,49378,51095,52810,54519,1852,113,123,84,71,56,53,51,48,
      44,39,33,32,38,54,78,106,132,155,172,185,199,215,221,211,190,163,139,123,
      119,123,132,139,147,151,155,161,171,187,207,232,260,290,324,364,411,462,
      517,573,631,692,755,827,914,1022,1146,1283,1423,1560,1688,1813,1941,2085,
      2253,2456,2693,2961,3248,3539,3814,4078,4332,4612,4962,5419,5971,6581,
      7201,7826,8445,9082,9811,10650,11531,12404,13271,14340,15624,16981,18320,
      19632,20995,22519,24150,25847,27493,29014,30431,31784,33085,34324,35479,
      36553,37550,38471,39320,40101,40818,41475,42075,42624,1312,92,85,69,52,40,
      39,35,32,29,26,23,22,24,29,37,47,56,62,64,62,60,58,57,57,58,59,60,62,65,
      70,75,82,87,92,95,99,105,113,124,137,151,166,183,202,224,248,273,299,326,
      353,383,415,450,490,534,584,637,694,754,818,889,969,1055,1146,1247,1356,
      1481,1636,1826,2044,2276,2522,2796,3110,3466,3853,4269,4732,5252,5834,
      6491,7214,7983,8787,9649,10744,12025,13332,14556,15727,17016,18539,20189,
      21905,23615,25298,26762,28133,29413,30615,31742,32794,33772,34679,35517,
      36289,36999,37651,38248,38793,1053,72,78,63,51,44,38,35,32,28,23,18,18,26,
      44,66,88,107,123,135,146,157,168,173,170,162,151,141,133,127,125,122,119,
      118,120,125,132,141,151,161,172,186,205,227,251,279,309,345,391,449,516,
      587,658,728,796,865,938,1018,1110,1221,1349,1490,1642,1816,2013,2229,2464,
      2710,2958,3203,3451,3715,4006,4326,4683,5080,5510,5978,6497,7072,7702,
      8392,9135,9913,10718,11563,12594,13737,14904,16056,17238,18563,20094,
      21748,23433,25058,26617,28001,29311,30545,31703,32784,33791,34724,35588,
      36384,37117,37790,38407,38971,39486,812,62,50,41,35,31,29,27,25,23,19,16,
      15,17,21,28,35,41,45,48,49,50,52,52,51,49,47,45,43,44,45,48,50,54,58,63,
      70,78,87,96,105,116,129,143,158,174,192,211,233,255,278,301,326,355,390,
      430,475,521,569,618,671,728,792,866,951,1048,1155,1269,1388,1510,1640,
      1781,1942,2130,2351,2603,2872,3164,3504,3911,4382,4903,5460,6069,6736,
      7471,8399,9432,10511,11613,12785,14143,15697,17324,18947,20568,22228,
      23729,25173,26551,27859,29094,30255,31342,32355,33297,34168,34973,35715,
      36397,37022 )
    temp2 <- -log(1- temp/100000)/365.24    #daily hazard rate

    #Add in the extrapolated data for 1990 and 2000
    temp <- array(0, c(111,2,10))
    temp[,,1:8] <- temp2
    fix <- c(0, .5, 1:109)
    fix  <- c(.00092*fix - .1615, .00020*fix - .1746)
    temp[,,9]   <- exp(log(temp[,,8]) + fix)
    temp[,,10]  <- exp(log(temp[,,9]) + fix)

    attributes(temp) <- list (
	dim      =c(111,2,10),
	dimnames =list(c(0, .5, 1:109), c("male", "female"), 1900+ 10*1:10),
	dimid    =c("age", "sex", "year"),
	factor   =c(0,1,10),
	cutpoints=list(c(0,.5,1:109)* 365.24, NULL, mdy.date(1,1, 191:200*10)),
	summary = function(R) {
		     x <- c(format(round(min(R[,1]) /365.24, 1)),
			    format(round(max(R[,1]) /355.24, 1)),
			    sum(R[,2]==1), sum(R[,2]==2))
		     x2<- as.character(as.date(c(min(R[,3]), max(R[,3]))))

		     paste("  age ranges from", x[1], "to", x[2], "years\n",
			   " male:", x[3], " female:", x[4], "\n",
			   " date of entry from", x2[1], "to", x2[2], "\n")
		     },
	class='ratetable')
    temp
    }
rm(fix, temp, temp2)

