% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save-plot.R
\name{ggsave2}
\alias{ggsave2}
\title{Save a ggplot2 graphic}
\usage{
ggsave2(
  plot = ggplot2::last_plot(),
  filename,
  device = NULL,
  path = NULL,
  width = 7,
  height = NULL,
  units = "in",
  dir = c("h", "v"),
  dpi = "retina",
  embed_fonts = FALSE,
  ...
)
}
\arguments{
\item{plot}{Plot to save, defaults to last plot displayed.}

\item{filename}{File name to create on disk.}

\item{device}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only). If
\code{NULL} (default), the device is guessed based on the \code{filename} extension.}

\item{path}{Path of the directory to save plot to: \code{path} and \code{filename}
are combined to create the fully qualified file name. Defaults to the
working directory.}

\item{width}{Plot size in \code{units} ("in", "cm", or "mm").}

\item{height}{Plot size in \code{units} ("in", "cm", or "mm"). If not supplied,
uses \code{0.618 * width} when \code{dir = "h"} and \code{1.618 * width} when \code{dir = "v"}.}

\item{units}{Units of plot size ("in", "cm", or "mm"). Default is inches.}

\item{dir}{Orientation of the plot. One of \code{h} (default) for horizontal or
\code{v} for vertical.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Only applies when converting pixel units,
as is typical for raster output types.}

\item{embed_fonts}{Logical. Use Ghostscript to embed fonts in a PDF graphic?}

\item{...}{Additional arguments passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}}
}
\value{
None. Called for side effects.
}
\description{
This is a wrapper around \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} with some ATLAS-specific
defaults. The aspect ratio is fixed to 0.618 (\href{https://en.wikipedia.org/wiki/Golden_ratio}{the golden ratio}) unless the height is
manually defined. Plots are automatically spell checked and warnings are
returned if there are possible mistakes. Finally, plots saved as a pdf have
the fonts embedded using \code{\link[extrafont:embed_fonts]{extrafont::embed_fonts()}}.
}
\examples{
\donttest{
library(ggplot2)
p <- ggplot(mtcars, aes(mpg, wt)) +
 geom_point()

ggsave2(p, "/mtcars.pdf", path = tempdir())
ggsave2(p, "/mtcars.png", path = tempdir())
}
}
