% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{catgl}
\alias{catgl}
\title{Print colored messages}
\usage{
catgl(..., .envir = parent.frame(), level = "DEBUG", .pal, .capture = FALSE)
}
\arguments{
\item{..., .envir}{passed to \code{\link[glue]{glue}}}

\item{level}{passed to \code{\link[dipsaus]{cat2}}}

\item{.pal}{see \code{pal} in \code{\link[dipsaus]{cat2}}}

\item{.capture}{logical, whether to capture message and return it without
printing}
}
\value{
The message as characters
}
\description{
Print colored messages
}
\details{
The level has order that sorted from low to high: \code{"DEBUG"},
\code{"DEFAULT"}, \code{"INFO"}, \code{"WARNING"}, \code{"ERROR"},
\code{"FATAL"}. Each different level will display different colors and
icons before the message. You can suppress messages with certain levels
by setting 'raveio' options via
\code{raveio_setopt('verbose_level', <level>)}. Messages with levels lower
than the threshold will be muffled. See examples.
}
\examples{

# ------------------ Basic Styles ---------------------

# Temporarily change verbose level for example
raveio_setopt('verbose_level', 'DEBUG', FALSE)

# debug
catgl('Debug message', level = 'DEBUG')

# default
catgl('Default message', level = 'DEFAULT')

# info
catgl('Info message', level = 'INFO')

# warning
catgl('Warning message', level = 'WARNING')

# error
catgl('Error message', level = 'ERROR')

try({
  # fatal, will call stop and raise error
  catgl('Error message', level = 'FATAL')
}, silent = TRUE)

# ------------------ Muffle messages ---------------------

# Temporarily change verbose level to 'WARNING'
raveio_setopt('verbose_level', 'WARNING', FALSE)

# default, muffled
catgl('Default message')

# message printed for level >= Warning
catgl('Default message', level = 'WARNING')
catgl('Default message', level = 'ERROR')



}
