% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_subset_vertex}
\alias{vcg_subset_vertex}
\title{Subset mesh by vertex}
\usage{
vcg_subset_vertex(x, selector)
}
\arguments{
\item{x}{surface mesh}

\item{selector}{logical vector (must not contain NA), and length must be
consistent with the number of vertices in \code{x}: which nodes are
to be kept}
}
\value{
A triangular mesh of class \code{'mesh3d'}, a subset of \code{x}
}
\description{
Subset mesh by vertex
}
\examples{

sphere <- vcg_sphere()

nv <- ncol(sphere$vb)

selector <- seq_len(nv) > (nv / 2)

sub <- vcg_subset_vertex(sphere, selector)

if(is_not_cran()) {
  rgl_view({

    # subset sphere will be displayed in red
    rgl_call("shade3d", sub, col = 'red')

    # Original sphere will be displayed as wireframe
    rgl_call("wire3d", sphere, col = (2 - selector))

  })
}


}
