% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github}
\alias{github}
\title{Retrieve raw R code from an .R file hosted on github website}
\usage{
github(url, method, padding)
}
\arguments{
\item{url}{Link to an R file on github website}

\item{method}{Not all websites are formatted consistently. To overcome this, try a different
method by setting the method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1 containing the R code from the target url. All code
   at the target url (including javascript, ruby, python) will be returned.
}
\description{
Retrieve raw R code from an .R file hosted on github website
}
\examples{
library(dplyr)
github("https://github.com/hadley/vis-eda/blob/master/travel.R")

# Same as above but provided to cat for easy viewing
github("https://github.com/hadley/vis-eda/blob/master/travel.R") \%>\%
  cat


}
