% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_image_overlay.R
\name{add_image_overlay}
\alias{add_image_overlay}
\title{Add Overlay}
\usage{
add_image_overlay(
  image,
  image_overlay = NULL,
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{image_overlay}{Default \code{NULL}. Either a string indicating the location of a png image to overlay
over the image (transparency included), or a 4-layer RGBA array. This image will be resized to the
dimension of the image if it does not match exactly.}

\item{filename}{Default \code{NULL}. File to save the image to. If \code{NULL} and \code{preview = FALSE},
returns an RGB array.}

\item{preview}{Default \code{FALSE}. If \code{TRUE}, it will display the image in addition
to returning it.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds an image overlay.
}
\examples{
#Plot the dragon
plot_image(dragon)

#Add an overlay of a red semi-transparent circle:
circlemat = generate_2d_disk(min(dim(dragon)[1:2]))
circlemat = circlemat/max(circlemat)

#Create RGBA image, with a transparency of 0.5
rgba_array = array(0, dim=c(nrow(circlemat),ncol(circlemat),4))
rgba_array[,,1] = circlemat
rgba_array[,,4] = 0.5
dragon_clipped = dragon
dragon_clipped[dragon_clipped > 1] = 1
\donttest{
add_image_overlay(dragon_clipped, image_overlay = rgba_array, preview = TRUE)
}
}
