% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_depth.R
\name{render_depth}
\alias{render_depth}
\title{Render Depth of Field}
\usage{
render_depth(focus = 0.5, focallength = 100, fstop = 4,
  filename = NULL, bokehshape = "circle", bokehintensity = 1,
  bokehlimit = 0.8, rotation = 0, gamma_correction = TRUE,
  transparent_water = FALSE, progbar = interactive())
}
\arguments{
\item{focus}{Defaults `0.5`. Depth in which to blur. Minimum 0, maximum 1.}

\item{focallength}{Default `1`. Focal length of the virtual camera.}

\item{fstop}{Default `1`. F-stop of the virtual camera.}

\item{filename}{The filename of the image to be saved. If this is not given, the image will be plotted instead.}

\item{bokehshape}{Default `circle`. Also built-in: `hex`. The shape of the bokeh.}

\item{bokehintensity}{Default `3`. Intensity of the bokeh when the pixel intensity is greater than `bokehlimit`.}

\item{bokehlimit}{Default `0.8`. Limit after which the bokeh intensity is increased by `bokehintensity`.}

\item{rotation}{Default `0`. Number of degrees to rotate the hexagon bokeh shape.}

\item{gamma_correction}{Default `TRUE`. Controls gamma correction when adding colors. Default exponent of 2.2.}

\item{transparent_water}{Default `FALSE`. If `TRUE`, depth is determined without water layer. User will have to re-render the water
layer with `render_water()` if they want to recreate the water layer.}

\item{progbar}{Default `TRUE` if in an interactive session. Displays a progress bar.}
}
\value{
4-layer RGBA array.
}
\description{
Adds depth of field to the current RGL scene by simulating a synthetic aperture. 

The size of the circle of confusion is determined by the following formula (z_depth is from the image's depth map).

\code{abs(z_depth-focus)*focal_length^2/(f_stop*z_depth*(focus - focal_length))}
}
\examples{
\donttest{
montereybay \%>\%
 sphere_shade() \%>\%
 plot_3d(montereybay,zscale=50,zoom=0.6,theta=-90)
 
render_depth(focallength = 30)
render_depth(focallength = 30,fstop=2)
render_depth(focallength = 30,fstop=2)
}
rgl::rgl.clear()
}
