% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_mesh.R
\name{validate_mesh}
\alias{validate_mesh}
\title{Validate Mesh Data}
\usage{
validate_mesh(mesh, validate_materials = TRUE)
}
\arguments{
\item{mesh}{List. A mesh is a list as described above.}

\item{validate_materials}{Default \code{TRUE}. Whether or not to validate "materials".}
}
\value{
A mesh.
}
\description{
This function takes a mesh and validates it. The mesh should be a list with
"shapes", "materials", "vertices", "texcoords", "normals", and "material_hashes" entries.
}
\section{Shapes}{

Each "shapes" entry should be a list with "mesh", "name", and "material" entries.
Each "mesh" entry should have "indices", "tex_indices", "norm_indices", "material_ids", "has_vertex_tex", and "has_vertex_normals".
The indices should not exceed the number of rows in their corresponding vertex/normal/texcoord data. There should be no NA/NaN values in the vertex/normal/texcoord data.
}

\section{Materials (for rayvertex package only)}{

Each "materials" entry is expected to be a list with several entries with specific required lengths, as listed below:\tabular{ccc}{
   Attribute \tab Length \tab Type \cr
   diffuse \tab 3 \tab Numeric \cr
   ambient \tab 3 \tab Numeric \cr
   specular \tab 3 \tab Numeric \cr
   transmittance \tab 3 \tab Numeric \cr
   emission \tab 3 \tab Numeric \cr
   shininess \tab 1 \tab Numeric \cr
   ior \tab 1 \tab Numeric \cr
   dissolve \tab 1 \tab Numeric \cr
   illum \tab 1 \tab Numeric \cr
   diffuse_texname \tab 1 \tab Character \cr
   normal_texname \tab 1 \tab Character \cr
   bump_texname \tab 1 \tab Character \cr
   specular_texname \tab 1 \tab Character \cr
   ambient_texname \tab 1 \tab Character \cr
   emissive_texname \tab 1 \tab Character \cr
   diffuse_intensity \tab 1 \tab Numeric \cr
   bump_intensity \tab 1 \tab Numeric \cr
   specular_intensity \tab 1 \tab Numeric \cr
   emission_intensity \tab 1 \tab Numeric \cr
   ambient_intensity \tab 1 \tab Numeric \cr
   culling \tab 1 \tab Character \cr
   type \tab 1 \tab Character \cr
   translucent \tab 1 \tab Logical \cr
   toon_levels \tab 1 \tab Numeric \cr
   toon_outline_width \tab 1 \tab Numeric \cr
   toon_outline_color \tab 3 \tab Numeric \cr
   reflection_intensity \tab 1 \tab Numeric \cr
   reflection_sharpness \tab 1 \tab Numeric \cr
   two_sided \tab 1 \tab Logical \cr
}


Note: This materials validation only applies to the rayvertex package. Other renderers might choose to use their own information in the material list.
}

\examples{
# validate a mesh
mesh = validate_mesh(sphere_mesh())
}
