% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/material_functions.R
\name{change_material}
\alias{change_material}
\title{Change Material}
\usage{
change_material(
  mesh,
  id = NULL,
  sub_id = 1,
  diffuse = NULL,
  ambient = NULL,
  specular = NULL,
  transmittance = NULL,
  emission = NULL,
  shininess = NULL,
  ior = NULL,
  dissolve = NULL,
  illum = NULL,
  texture_location = NULL,
  normal_texture_location = NULL,
  specular_texture_location = NULL,
  ambient_texture_location = NULL,
  emissive_texture_location = NULL,
  diffuse_intensity = NULL,
  specular_intensity = NULL,
  emission_intensity = NULL,
  ambient_intensity = NULL,
  culling = NULL,
  type = NULL,
  translucent = NULL,
  toon_levels = NULL,
  toon_outline_width = NULL,
  toon_outline_color = NULL,
  reflection_intensity = NULL,
  reflection_sharpness = NULL,
  two_sided = NULL
)
}
\arguments{
\item{mesh}{Mesh to change.}

\item{id}{Default `NULL`. Either a number specifying the material to change, or a character vector 
matching the material name.}

\item{sub_id}{Default `1`. A number specifying which material to change (within an id).}

\item{diffuse}{Default `NULL`. The diffuse color.}

\item{ambient}{Default `NULL`. The ambient color.}

\item{specular}{Default `NULL`. The specular color.}

\item{transmittance}{Default `NULL`. The transmittance}

\item{emission}{Default `NULL`. The emissive color.}

\item{shininess}{Default `NULL`. The shininess exponent.}

\item{ior}{Default `NULL`. The index of refraction. If this is not equal to `1.0`, the material will be refractive.}

\item{dissolve}{Default `NULL`. The transparency.}

\item{illum}{Default `NULL`. The illumination.}

\item{texture_location}{Default `NULL`. The diffuse texture location.}

\item{normal_texture_location}{Default `NULL`. The normal texture location.}

\item{specular_texture_location}{Default `NULL`. The specular texture location.}

\item{ambient_texture_location}{Default `NULL`. The ambient texture location.}

\item{emissive_texture_location}{Default `NULL`. The emissive texture location.}

\item{diffuse_intensity}{Default `NULL`. The diffuse intensity.}

\item{specular_intensity}{Default `NULL`. The specular intensity.}

\item{emission_intensity}{Default `NULL`. The emission intensity.}

\item{ambient_intensity}{Default `NULL`. The ambient intensity.}

\item{culling}{Default `NULL`. The culling type. Options are `back`, `front`, and `none`.}

\item{type}{Default `NULL`. The shader type. Options include `diffuse`,`phong`,`vertex`, and `color`.}

\item{translucent}{Default `NULL`. Whether light should transmit through a semi-transparent material.}

\item{toon_levels}{Default `NULL`. Number of color breaks in the toon shader.}

\item{toon_outline_width}{Default `NULL`. Expansion term for model to specify toon outline width. Note: setting this property via this function currently does not generate outlines. Specify it during object creation.}

\item{toon_outline_color}{Default `NULL`. Toon outline color.Note: setting this property via this function currently does not color outlines. Specify it during object creation.}

\item{reflection_intensity}{Default `NULL`. Intensity of the reflection of the environment map, if present. This will be ignored if the material is refractive.}

\item{reflection_sharpness}{Default `NULL`. Sharpness of the reflection, where lower values have blurrier reflections. Must be greater than zero and less than one.}

\item{two_sided}{Default `NULL`. Whether diffuse materials should be two sided (normal is taken as the absolute value of the dot product of the light direction and the normal).}
}
\value{
Shape with new material settings
}
\description{
Change individual material properties, leaving others alone.
}
\examples{
if(rayvertex:::run_documentation()) {
p_sphere = sphere_mesh(position=c(555/2,555/2,555/2), 
                      radius=40,material=material_list(diffuse="purple"))
generate_cornell_mesh() |>
 add_shape(p_sphere) |>
 add_shape(change_material(translate_mesh(p_sphere,c(200,0,0)),diffuse="red")) |>
 add_shape(change_material(translate_mesh(p_sphere,c(100,0,0)),dissolve=0.5)) |>
 add_shape(change_material(translate_mesh(p_sphere,c(-100,0,0)),type="phong")) |>
 add_shape(change_material(translate_mesh(p_sphere,c(-200,0,0)),type="phong",shininess=30)) |>
 rasterize_scene(light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
