% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilFuncs.R
\name{int2date}
\alias{int2date}
\title{Convert time stamp to POSIX}
\usage{
int2date(x)
}
\arguments{
\item{x}{\code{integer}, the block header time stamp}
}
\value{
An object of class \code{POSIXct, POSIXt}
}
\description{
This function returns the associated \code{POSIXct} time
to the time stamp integer in a block header.
}
\examples{
ts <- 1532954868
int2date(ts)
}
\references{
\url{https://en.bitcoin.it/wiki/Block_timestamp}
}
\seealso{
Other UtilityFuncs: 
\code{\link{bkfee}()},
\code{\link{blockattime}()},
\code{\link{blockstats}()},
\code{\link{date2int}()},
\code{\link{intMaxDay}()},
\code{\link{intMinDay}()},
\code{\link{intRangeDay}()},
\code{\link{intRangePeriod}()},
\code{\link{timeofblock}()},
\code{\link{txfee}()},
\code{\link{txids}()},
\code{\link{txinids}()},
\code{\link{txstats}()},
\code{\link{utxoage}()},
\code{\link{utxotype}()},
\code{\link{utxovalue}()}
}
\author{
Bernhard Pfaff
}
\concept{UtilityFuncs}
