% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-biomes.R
\name{LegacyBiomes}
\alias{LegacyBiomes}
\alias{get_legacy_biomes_value}
\alias{get_legacy_biomes_data}
\alias{put_legacy_biomes_value}
\alias{put_legacy_biomes_data}
\title{Read and write legacy biomes data}
\usage{
get_legacy_biomes_value(
  x,
  z,
  dimension,
  db = default_db(),
  return_names = TRUE
)

get_legacy_biomes_data(x, z, dimension, db = default_db(), return_names = TRUE)

put_legacy_biomes_value(
  value,
  x,
  z,
  dimension,
  db = default_db(),
  missing_height = 0L
)

put_legacy_biomes_data(
  values,
  x,
  z,
  dimension,
  db = default_db(),
  missing_height = 0L
)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{return_names}{return biome names instead of biome ids.}

\item{value}{A 16x16 matrix of biome ids.}

\item{missing_height}{if there is no existing height data, use this value
for the chunk.}

\item{values}{A (named) list of LegacyBiomes values. If \code{x} is missing, the
names of \code{values} will be taken as the keys.}
}
\value{
\code{get_legacy_biomes_value()} returns a legacy biomes data value.
\code{get_legacy_biomes_data()} returns a named list of legacy biomes data values.
Legacy biomes data values are 16x16 matrices containing biome data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Legacy Biomes data is stored as the second map in the \link{Data2D} data (tag 45).
\itemize{
\item \code{get_legacy_biomes_value()} and \code{get_legacy_biomes_data()} load legacy
biomes data from \code{db}. \code{get_legacy_biomes_value()} loads data for a single
chunk, and \code{get_legacy_biomes_data()} loads data for multiple chunks.
\item \code{put_legacy_biomes_value()} and \code{put_legacy_biomes_data()} store legacy
biomes data into \code{db}.
}
}
\seealso{
Biomes
}
\keyword{internal}
